/*
 * Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
'use strict';
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var AskSdkUtils_1 = require("../util/AskSdkUtils");
/**
 * Default implementation of {@link RequestDispatcher}.
 */
var DefaultRequestDispatcher = /** @class */ (function () {
    function DefaultRequestDispatcher(options) {
        this.requestMappers = options.requestMappers;
        this.handlerAdapters = options.handlerAdapters;
        this.errorMapper = options.errorMapper;
        this.requestInterceptors = options.requestInterceptors;
        this.responseInterceptors = options.responseInterceptors;
    }
    /**
     * Main entry point for dispatching logic.
     * Dispatches handlerInput to requestHandlers and error, if any, to _errorHandlers
     * @param {HandlerInput} handlerInput
     * @returns {Promise<Response>}
     */
    DefaultRequestDispatcher.prototype.dispatch = function (handlerInput) {
        return __awaiter(this, void 0, void 0, function () {
            var response, _i, _a, requestInterceptor, _b, _c, responseInterceptor, err_1;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        _d.trys.push([0, 10, , 12]);
                        if (!this.requestInterceptors) return [3 /*break*/, 4];
                        _i = 0, _a = this.requestInterceptors;
                        _d.label = 1;
                    case 1:
                        if (!(_i < _a.length)) return [3 /*break*/, 4];
                        requestInterceptor = _a[_i];
                        return [4 /*yield*/, requestInterceptor.process(handlerInput)];
                    case 2:
                        _d.sent();
                        _d.label = 3;
                    case 3:
                        _i++;
                        return [3 /*break*/, 1];
                    case 4: return [4 /*yield*/, this.dispatchRequest(handlerInput)];
                    case 5:
                        // Dispatch request to handler chain
                        response = _d.sent();
                        if (!this.responseInterceptors) return [3 /*break*/, 9];
                        _b = 0, _c = this.responseInterceptors;
                        _d.label = 6;
                    case 6:
                        if (!(_b < _c.length)) return [3 /*break*/, 9];
                        responseInterceptor = _c[_b];
                        return [4 /*yield*/, responseInterceptor.process(handlerInput, response)];
                    case 7:
                        _d.sent();
                        _d.label = 8;
                    case 8:
                        _b++;
                        return [3 /*break*/, 6];
                    case 9: return [3 /*break*/, 12];
                    case 10:
                        err_1 = _d.sent();
                        return [4 /*yield*/, this.dispatchError(handlerInput, err_1)];
                    case 11:
                        response = _d.sent();
                        return [3 /*break*/, 12];
                    case 12: return [2 /*return*/, response];
                }
            });
        });
    };
    /**
     * Main logic for request dispatching. Binds the forwarding function to the handlerInput
     * @param {HandlerInput} handlerInput
     * @returns {Promise<Response>}
     */
    DefaultRequestDispatcher.prototype.dispatchRequest = function (handlerInput) {
        return __awaiter(this, void 0, void 0, function () {
            var handlerChain, _i, _a, requestMapper, handler, requestInterceptors, responseInterceptors, adapter, _b, _c, handlerAdapter, _d, requestInterceptors_1, requestInterceptor, response, _e, responseInterceptors_1, responseInterceptor;
            return __generator(this, function (_f) {
                switch (_f.label) {
                    case 0:
                        _i = 0, _a = this.requestMappers;
                        _f.label = 1;
                    case 1:
                        if (!(_i < _a.length)) return [3 /*break*/, 4];
                        requestMapper = _a[_i];
                        return [4 /*yield*/, requestMapper.getRequestHandlerChain(handlerInput)];
                    case 2:
                        handlerChain = _f.sent();
                        if (handlerChain) {
                            return [3 /*break*/, 4];
                        }
                        _f.label = 3;
                    case 3:
                        _i++;
                        return [3 /*break*/, 1];
                    case 4:
                        if (!handlerChain) {
                            throw AskSdkUtils_1.createAskSdkError(this.constructor.name, "Could not find handler that can handle the request: " + JSON.stringify(handlerInput.requestEnvelope.request, null, 2));
                        }
                        handler = handlerChain.getRequestHandler();
                        requestInterceptors = handlerChain.getRequestInterceptors();
                        responseInterceptors = handlerChain.getResponseInterceptors();
                        for (_b = 0, _c = this.handlerAdapters; _b < _c.length; _b++) {
                            handlerAdapter = _c[_b];
                            if (handlerAdapter.supports(handler)) {
                                adapter = handlerAdapter;
                                break;
                            }
                        }
                        if (!adapter) {
                            throw AskSdkUtils_1.createAskSdkError(this.constructor.name, "Could not find the handler adapter that supports the request handler.");
                        }
                        if (!requestInterceptors) return [3 /*break*/, 8];
                        _d = 0, requestInterceptors_1 = requestInterceptors;
                        _f.label = 5;
                    case 5:
                        if (!(_d < requestInterceptors_1.length)) return [3 /*break*/, 8];
                        requestInterceptor = requestInterceptors_1[_d];
                        return [4 /*yield*/, requestInterceptor.process(handlerInput)];
                    case 6:
                        _f.sent();
                        _f.label = 7;
                    case 7:
                        _d++;
                        return [3 /*break*/, 5];
                    case 8: return [4 /*yield*/, adapter.execute(handlerInput, handler)];
                    case 9:
                        response = _f.sent();
                        if (!responseInterceptors) return [3 /*break*/, 13];
                        _e = 0, responseInterceptors_1 = responseInterceptors;
                        _f.label = 10;
                    case 10:
                        if (!(_e < responseInterceptors_1.length)) return [3 /*break*/, 13];
                        responseInterceptor = responseInterceptors_1[_e];
                        return [4 /*yield*/, responseInterceptor.process(handlerInput, response)];
                    case 11:
                        _f.sent();
                        _f.label = 12;
                    case 12:
                        _e++;
                        return [3 /*break*/, 10];
                    case 13: return [2 /*return*/, response];
                }
            });
        });
    };
    /**
     * Main logic for error dispatching.
     * @param {HandlerInput} handlerInput
     * @param {Error} error
     * @returns {Promise<Response>}
     */
    DefaultRequestDispatcher.prototype.dispatchError = function (handlerInput, error) {
        return __awaiter(this, void 0, void 0, function () {
            var handler;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.errorMapper) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.errorMapper.getErrorHandler(handlerInput, error)];
                    case 1:
                        handler = _a.sent();
                        if (handler) {
                            return [2 /*return*/, handler.handle(handlerInput, error)];
                        }
                        _a.label = 2;
                    case 2: throw error;
                }
            });
        });
    };
    return DefaultRequestDispatcher;
}());
exports.DefaultRequestDispatcher = DefaultRequestDispatcher;
//# sourceMappingURL=DefaultRequestDispatcher.js.map