/*
 * Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
'use strict';
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var ask_sdk_core_1 = require("ask-sdk-core");
var ask_sdk_dynamodb_persistence_adapter_1 = require("ask-sdk-dynamodb-persistence-adapter");
/**
 * Provider for {@link StandardSkillBuilder}.
 */
var StandardSkillFactory = /** @class */ (function () {
    function StandardSkillFactory() {
    }
    StandardSkillFactory.init = function () {
        var thisTableName;
        var thisAutoCreateTable;
        var thisPartitionKeyGenerator;
        var thisDynamoDbClient;
        var baseSkillBuilder = ask_sdk_core_1.BaseSkillFactory.init();
        return __assign({}, baseSkillBuilder, { getSkillConfiguration: function () {
                var skillConfiguration = baseSkillBuilder.getSkillConfiguration();
                return __assign({}, skillConfiguration, { persistenceAdapter: thisTableName
                        ? new ask_sdk_dynamodb_persistence_adapter_1.DynamoDbPersistenceAdapter({
                            tableName: thisTableName,
                            createTable: thisAutoCreateTable,
                            partitionKeyGenerator: thisPartitionKeyGenerator,
                            dynamoDBClient: thisDynamoDbClient,
                        })
                        : undefined, apiClient: new ask_sdk_core_1.DefaultApiClient() });
            },
            withTableName: function (tableName) {
                thisTableName = tableName;
                return this;
            },
            withAutoCreateTable: function (autoCreateTable) {
                thisAutoCreateTable = autoCreateTable;
                return this;
            },
            withPartitionKeyGenerator: function (partitionKeyGenerator) {
                thisPartitionKeyGenerator = partitionKeyGenerator;
                return this;
            },
            withDynamoDbClient: function (dynamoDbClient) {
                thisDynamoDbClient = dynamoDbClient;
                return this;
            } });
    };
    return StandardSkillFactory;
}());
exports.StandardSkillFactory = StandardSkillFactory;
//# sourceMappingURL=StandardSkillFactory.js.map