import { RequestEnvelope } from 'ask-sdk-model';
/**
 * Type definition of function used by {@link DynamoDbPersistenceAdapter} to extract attributes id from {@link RequestEnvelope}.
 */
export declare type PartitionKeyGenerator = (requestEnvelope: RequestEnvelope) => string;
/**
 * Object containing implementations of {@link PartitionKeyGenerator}.
 */
export declare const PartitionKeyGenerators: {
    /**
     * Gets attributes id using user id.
     * @param {RequestEnvelope} requestEnvelope
     * @returns {string}
     */
    userId(requestEnvelope: RequestEnvelope): string;
    /**
     * Gets attributes id using device id.
     * @param {RequestEnvelope} requestEnvelope
     * @returns {string}
     */
    deviceId(requestEnvelope: RequestEnvelope): string;
};
