/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.webview;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Picture;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.CookieManager;
import android.webkit.GeolocationPermissions;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.ContentSizeChangeEvent;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.webview.WebViewConfig;
import com.facebook.react.views.webview.events.TopLoadingErrorEvent;
import com.facebook.react.views.webview.events.TopLoadingFinishEvent;
import com.facebook.react.views.webview.events.TopLoadingStartEvent;
import com.facebook.react.views.webview.events.TopMessageEvent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@ReactModule(name="RCTWebView")
public class ReactWebViewManager
extends SimpleViewManager<WebView> {
    protected static final String REACT_CLASS = "RCTWebView";
    protected static final String HTML_ENCODING = "UTF-8";
    protected static final String HTML_MIME_TYPE = "text/html";
    protected static final String BRIDGE_NAME = "__REACT_WEB_VIEW_BRIDGE";
    protected static final String HTTP_METHOD_POST = "POST";
    public static final int COMMAND_GO_BACK = 1;
    public static final int COMMAND_GO_FORWARD = 2;
    public static final int COMMAND_RELOAD = 3;
    public static final int COMMAND_STOP_LOADING = 4;
    public static final int COMMAND_POST_MESSAGE = 5;
    public static final int COMMAND_INJECT_JAVASCRIPT = 6;
    protected static final String BLANK_URL = "about:blank";
    protected WebViewConfig mWebViewConfig;
    @Nullable
    protected WebView.PictureListener mPictureListener;

    public ReactWebViewManager() {
        this.mWebViewConfig = new WebViewConfig(){

            @Override
            public void configWebView(WebView webView) {
            }
        };
    }

    public ReactWebViewManager(WebViewConfig webViewConfig) {
        this.mWebViewConfig = webViewConfig;
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    protected ReactWebView createReactWebViewInstance(ThemedReactContext reactContext) {
        return new ReactWebView(reactContext);
    }

    @Override
    protected WebView createViewInstance(ThemedReactContext reactContext) {
        ReactWebView webView = this.createReactWebViewInstance(reactContext);
        webView.setWebChromeClient(new WebChromeClient(){

            public boolean onConsoleMessage(ConsoleMessage message) {
                return true;
            }

            public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
                callback.invoke(origin, true, false);
            }
        });
        reactContext.addLifecycleEventListener(webView);
        this.mWebViewConfig.configWebView(webView);
        webView.getSettings().setBuiltInZoomControls(true);
        webView.getSettings().setDisplayZoomControls(false);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return webView;
    }

    @ReactProp(name="javaScriptEnabled")
    public void setJavaScriptEnabled(WebView view, boolean enabled) {
        view.getSettings().setJavaScriptEnabled(enabled);
    }

    @ReactProp(name="thirdPartyCookiesEnabled")
    public void setThirdPartyCookiesEnabled(WebView view, boolean enabled) {
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(view, enabled);
        }
    }

    @ReactProp(name="scalesPageToFit")
    public void setScalesPageToFit(WebView view, boolean enabled) {
        view.getSettings().setUseWideViewPort(!enabled);
    }

    @ReactProp(name="domStorageEnabled")
    public void setDomStorageEnabled(WebView view, boolean enabled) {
        view.getSettings().setDomStorageEnabled(enabled);
    }

    @ReactProp(name="userAgent")
    public void setUserAgent(WebView view, @Nullable String userAgent) {
        if (userAgent != null) {
            view.getSettings().setUserAgentString(userAgent);
        }
    }

    @ReactProp(name="mediaPlaybackRequiresUserAction")
    public void setMediaPlaybackRequiresUserAction(WebView view, boolean requires) {
        view.getSettings().setMediaPlaybackRequiresUserGesture(requires);
    }

    @ReactProp(name="allowUniversalAccessFromFileURLs")
    public void setAllowUniversalAccessFromFileURLs(WebView view, boolean allow) {
        view.getSettings().setAllowUniversalAccessFromFileURLs(allow);
    }

    @ReactProp(name="saveFormDataDisabled")
    public void setSaveFormDataDisabled(WebView view, boolean disable) {
        view.getSettings().setSaveFormData(!disable);
    }

    @ReactProp(name="injectedJavaScript")
    public void setInjectedJavaScript(WebView view, @Nullable String injectedJavaScript) {
        ((ReactWebView)view).setInjectedJavaScript(injectedJavaScript);
    }

    @ReactProp(name="messagingEnabled")
    public void setMessagingEnabled(WebView view, boolean enabled) {
        ((ReactWebView)view).setMessagingEnabled(enabled);
    }

    @ReactProp(name="source")
    public void setSource(WebView view, @Nullable ReadableMap source) {
        if (source != null) {
            if (source.hasKey("html")) {
                String html = source.getString("html");
                if (source.hasKey("baseUrl")) {
                    view.loadDataWithBaseURL(source.getString("baseUrl"), html, HTML_MIME_TYPE, HTML_ENCODING, null);
                } else {
                    view.loadData(html, HTML_MIME_TYPE, HTML_ENCODING);
                }
                return;
            }
            if (source.hasKey("uri")) {
                String method;
                String url = source.getString("uri");
                String previousUrl = view.getUrl();
                if (previousUrl != null && previousUrl.equals(url)) {
                    return;
                }
                if (source.hasKey("method") && (method = source.getString("method")).equals(HTTP_METHOD_POST)) {
                    byte[] postData = null;
                    if (source.hasKey("body")) {
                        String body = source.getString("body");
                        try {
                            postData = body.getBytes(HTML_ENCODING);
                        }
                        catch (UnsupportedEncodingException e) {
                            postData = body.getBytes();
                        }
                    }
                    if (postData == null) {
                        postData = new byte[]{};
                    }
                    view.postUrl(url, postData);
                    return;
                }
                HashMap<String, String> headerMap = new HashMap<String, String>();
                if (source.hasKey("headers")) {
                    ReadableMap headers = source.getMap("headers");
                    ReadableMapKeySetIterator iter = headers.keySetIterator();
                    while (iter.hasNextKey()) {
                        String key = iter.nextKey();
                        if ("user-agent".equals(key.toLowerCase(Locale.ENGLISH))) {
                            if (view.getSettings() == null) continue;
                            view.getSettings().setUserAgentString(headers.getString(key));
                            continue;
                        }
                        headerMap.put(key, headers.getString(key));
                    }
                }
                view.loadUrl(url, headerMap);
                return;
            }
        }
        view.loadUrl(BLANK_URL);
    }

    @ReactProp(name="onContentSizeChange")
    public void setOnContentSizeChange(WebView view, boolean sendContentSizeChangeEvents) {
        if (sendContentSizeChangeEvents) {
            view.setPictureListener(this.getPictureListener());
        } else {
            view.setPictureListener(null);
        }
    }

    @ReactProp(name="mixedContentMode")
    public void setMixedContentMode(WebView view, @Nullable String mixedContentMode) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (mixedContentMode == null || "never".equals(mixedContentMode)) {
                view.getSettings().setMixedContentMode(1);
            } else if ("always".equals(mixedContentMode)) {
                view.getSettings().setMixedContentMode(0);
            } else if ("compatibility".equals(mixedContentMode)) {
                view.getSettings().setMixedContentMode(2);
            }
        }
    }

    @ReactProp(name="urlPrefixesForDefaultIntent")
    public void setUrlPrefixesForDefaultIntent(WebView view, @Nullable ReadableArray urlPrefixesForDefaultIntent) {
        ReactWebViewClient client = ((ReactWebView)view).getReactWebViewClient();
        if (client != null && urlPrefixesForDefaultIntent != null) {
            client.setUrlPrefixesForDefaultIntent(urlPrefixesForDefaultIntent);
        }
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, WebView view) {
        view.setWebViewClient((WebViewClient)new ReactWebViewClient());
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("goBack", 1, "goForward", 2, "reload", 3, "stopLoading", 4, "postMessage", 5, "injectJavaScript", 6);
    }

    @Override
    public void receiveCommand(WebView root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                root.goBack();
                break;
            }
            case 2: {
                root.goForward();
                break;
            }
            case 3: {
                root.reload();
                break;
            }
            case 4: {
                root.stopLoading();
                break;
            }
            case 5: {
                try {
                    JSONObject eventInitDict = new JSONObject();
                    eventInitDict.put("data", (Object)args.getString(0));
                    root.loadUrl("javascript:(function () {var event;var data = " + eventInitDict.toString() + ";try {event = new MessageEvent('message', data);} catch (e) {event = document.createEvent('MessageEvent');event.initMessageEvent('message', true, true, data.data, data.origin, data.lastEventId, data.source);}document.dispatchEvent(event);})();");
                    break;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            case 6: {
                root.loadUrl("javascript:" + args.getString(0));
            }
        }
    }

    @Override
    public void onDropViewInstance(WebView webView) {
        super.onDropViewInstance(webView);
        ((ThemedReactContext)webView.getContext()).removeLifecycleEventListener((ReactWebView)webView);
        ((ReactWebView)webView).cleanupCallbacksAndDestroy();
    }

    protected WebView.PictureListener getPictureListener() {
        if (this.mPictureListener == null) {
            this.mPictureListener = new WebView.PictureListener(){

                public void onNewPicture(WebView webView, Picture picture) {
                    ReactWebViewManager.dispatchEvent(webView, new ContentSizeChangeEvent(webView.getId(), webView.getWidth(), webView.getContentHeight()));
                }
            };
        }
        return this.mPictureListener;
    }

    protected static void dispatchEvent(WebView webView, Event event) {
        ReactContext reactContext = (ReactContext)webView.getContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        eventDispatcher.dispatchEvent(event);
    }

    protected static class ReactWebView
    extends WebView
    implements LifecycleEventListener {
        @Nullable
        protected String injectedJS;
        protected boolean messagingEnabled = false;
        @Nullable
        protected ReactWebViewClient mReactWebViewClient;

        public ReactWebView(ThemedReactContext reactContext) {
            super((Context)reactContext);
        }

        @Override
        public void onHostResume() {
        }

        @Override
        public void onHostPause() {
        }

        @Override
        public void onHostDestroy() {
            this.cleanupCallbacksAndDestroy();
        }

        public void setWebViewClient(WebViewClient client) {
            super.setWebViewClient(client);
            this.mReactWebViewClient = (ReactWebViewClient)client;
        }

        @Nullable
        public ReactWebViewClient getReactWebViewClient() {
            return this.mReactWebViewClient;
        }

        public void setInjectedJavaScript(@Nullable String js) {
            this.injectedJS = js;
        }

        protected ReactWebViewBridge createReactWebViewBridge(ReactWebView webView) {
            return new ReactWebViewBridge(webView);
        }

        public void setMessagingEnabled(boolean enabled) {
            if (this.messagingEnabled == enabled) {
                return;
            }
            this.messagingEnabled = enabled;
            if (enabled) {
                this.addJavascriptInterface(this.createReactWebViewBridge(this), ReactWebViewManager.BRIDGE_NAME);
                this.linkBridge();
            } else {
                this.removeJavascriptInterface(ReactWebViewManager.BRIDGE_NAME);
            }
        }

        public void callInjectedJavaScript() {
            if (this.getSettings().getJavaScriptEnabled() && this.injectedJS != null && !TextUtils.isEmpty((CharSequence)this.injectedJS)) {
                this.loadUrl("javascript:(function() {\n" + this.injectedJS + ";\n})();");
            }
        }

        public void linkBridge() {
            if (this.messagingEnabled) {
                this.loadUrl("javascript:(window.originalPostMessage = window.postMessage,window.postMessage = function(data) {__REACT_WEB_VIEW_BRIDGE.postMessage(String(data));})");
            }
        }

        public void onMessage(String message) {
            ReactWebViewManager.dispatchEvent(this, new TopMessageEvent(this.getId(), message));
        }

        protected void cleanupCallbacksAndDestroy() {
            this.setWebViewClient(null);
            this.destroy();
        }

        protected class ReactWebViewBridge {
            ReactWebView mContext;

            ReactWebViewBridge(ReactWebView c) {
                this.mContext = c;
            }

            @JavascriptInterface
            public void postMessage(String message) {
                this.mContext.onMessage(message);
            }
        }
    }

    protected static class ReactWebViewClient
    extends WebViewClient {
        protected boolean mLastLoadFailed = false;
        @Nullable
        protected ReadableArray mUrlPrefixesForDefaultIntent;

        protected ReactWebViewClient() {
        }

        public void onPageFinished(WebView webView, String url) {
            super.onPageFinished(webView, url);
            if (!this.mLastLoadFailed) {
                ReactWebView reactWebView = (ReactWebView)webView;
                reactWebView.callInjectedJavaScript();
                reactWebView.linkBridge();
                this.emitFinishEvent(webView, url);
            }
        }

        public void onPageStarted(WebView webView, String url, Bitmap favicon) {
            super.onPageStarted(webView, url, favicon);
            this.mLastLoadFailed = false;
            ReactWebViewManager.dispatchEvent(webView, new TopLoadingStartEvent(webView.getId(), this.createWebViewEvent(webView, url)));
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            boolean useDefaultIntent = false;
            if (this.mUrlPrefixesForDefaultIntent != null && this.mUrlPrefixesForDefaultIntent.size() > 0) {
                ArrayList<Object> urlPrefixesForDefaultIntent = this.mUrlPrefixesForDefaultIntent.toArrayList();
                for (Object urlPrefix : urlPrefixesForDefaultIntent) {
                    if (!url.startsWith((String)urlPrefix)) continue;
                    useDefaultIntent = true;
                    break;
                }
            }
            if (!useDefaultIntent && (url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file://") || url.equals(ReactWebViewManager.BLANK_URL))) {
                return false;
            }
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.setFlags(0x10000000);
                view.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                FLog.w((String)"ReactNative", (String)("activity not found to handle uri scheme for: " + url), (Throwable)e);
            }
            return true;
        }

        public void onReceivedError(WebView webView, int errorCode, String description, String failingUrl) {
            super.onReceivedError(webView, errorCode, description, failingUrl);
            this.mLastLoadFailed = true;
            this.emitFinishEvent(webView, failingUrl);
            WritableMap eventData = this.createWebViewEvent(webView, failingUrl);
            eventData.putDouble("code", errorCode);
            eventData.putString("description", description);
            ReactWebViewManager.dispatchEvent(webView, new TopLoadingErrorEvent(webView.getId(), eventData));
        }

        protected void emitFinishEvent(WebView webView, String url) {
            ReactWebViewManager.dispatchEvent(webView, new TopLoadingFinishEvent(webView.getId(), this.createWebViewEvent(webView, url)));
        }

        protected WritableMap createWebViewEvent(WebView webView, String url) {
            WritableMap event = Arguments.createMap();
            event.putDouble("target", webView.getId());
            event.putString("url", url);
            event.putBoolean("loading", !this.mLastLoadFailed && webView.getProgress() != 100);
            event.putString("title", webView.getTitle());
            event.putBoolean("canGoBack", webView.canGoBack());
            event.putBoolean("canGoForward", webView.canGoForward());
            return event;
        }

        public void setUrlPrefixesForDefaultIntent(ReadableArray specialUrls) {
            this.mUrlPrefixesForDefaultIntent = specialUrls;
        }
    }
}

