/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.imagepipeline.cache.CountingMemoryCache;

public class BitmapMemoryCacheTrimStrategy
implements CountingMemoryCache.CacheTrimStrategy {
    private static final String TAG = "BitmapMemoryCacheTrimStrategy";

    @Override
    public double getTrimRatio(MemoryTrimType trimType) {
        switch (trimType) {
            case OnCloseToDalvikHeapLimit: {
                if (Build.VERSION.SDK_INT >= 21) {
                    return MemoryTrimType.OnCloseToDalvikHeapLimit.getSuggestedTrimRatio();
                }
                return 0.0;
            }
            case OnAppBackgrounded: 
            case OnSystemLowMemoryWhileAppInForeground: 
            case OnSystemLowMemoryWhileAppInBackground: {
                return 1.0;
            }
        }
        FLog.wtf((String)TAG, (String)"unknown trim type: %s", (Object[])new Object[]{trimType});
        return 0.0;
    }
}

