/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.fbui.textlayoutbuilder;

import android.content.res.ColorStateList;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.Px;
import android.support.annotation.VisibleForTesting;
import android.support.v4.text.TextDirectionHeuristicCompat;
import android.support.v4.text.TextDirectionHeuristicsCompat;
import android.support.v4.util.LruCache;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.ClickableSpan;
import android.util.Log;
import com.facebook.fbui.textlayoutbuilder.GlyphWarmer;
import com.facebook.fbui.textlayoutbuilder.StaticLayoutHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TextLayoutBuilder {
    public static final int MEASURE_MODE_UNSPECIFIED = 0;
    public static final int MEASURE_MODE_EXACTLY = 1;
    public static final int MEASURE_MODE_AT_MOST = 2;
    public static final int DEFAULT_MAX_LINES = Integer.MAX_VALUE;
    @VisibleForTesting
    static final LruCache<Integer, Layout> sCache = new LruCache(100);
    @VisibleForTesting
    final Params mParams = new Params();
    private Layout mSavedLayout = null;
    private GlyphWarmer mGlyphWarmer;
    private boolean mShouldCacheLayout = true;
    private boolean mShouldWarmText = false;

    public TextLayoutBuilder setWidth(@Px int width) {
        return this.setWidth(width, width <= 0 ? 0 : 1);
    }

    public TextLayoutBuilder setWidth(@Px int width, int measureMode) {
        if (this.mParams.width != width || this.mParams.measureMode != measureMode) {
            this.mParams.width = width;
            this.mParams.measureMode = measureMode;
            this.mSavedLayout = null;
        }
        return this;
    }

    public CharSequence getText() {
        return this.mParams.text;
    }

    public TextLayoutBuilder setText(CharSequence text) {
        if (text == this.mParams.text || text != null && this.mParams.text != null && text.equals(this.mParams.text)) {
            return this;
        }
        this.mParams.text = text;
        this.mSavedLayout = null;
        return this;
    }

    public float getTextSize() {
        return this.mParams.paint.getTextSize();
    }

    public TextLayoutBuilder setTextSize(int size) {
        if (this.mParams.paint.getTextSize() != (float)size) {
            this.mParams.createNewPaintIfNeeded();
            this.mParams.paint.setTextSize((float)size);
            this.mSavedLayout = null;
        }
        return this;
    }

    @ColorInt
    public int getTextColor() {
        return this.mParams.paint.getColor();
    }

    public TextLayoutBuilder setTextColor(@ColorInt int color) {
        this.mParams.createNewPaintIfNeeded();
        this.mParams.color = null;
        this.mParams.paint.setColor(color);
        this.mSavedLayout = null;
        return this;
    }

    public TextLayoutBuilder setTextColor(ColorStateList colorStateList) {
        this.mParams.createNewPaintIfNeeded();
        this.mParams.color = colorStateList;
        this.mParams.paint.setColor(this.mParams.color != null ? this.mParams.color.getDefaultColor() : -16777216);
        this.mSavedLayout = null;
        return this;
    }

    @ColorInt
    public int getLinkColor() {
        return this.mParams.paint.linkColor;
    }

    public TextLayoutBuilder setLinkColor(@ColorInt int linkColor) {
        if (this.mParams.paint.linkColor != linkColor) {
            this.mParams.createNewPaintIfNeeded();
            this.mParams.paint.linkColor = linkColor;
            this.mSavedLayout = null;
        }
        return this;
    }

    public float getTextSpacingExtra() {
        return this.mParams.spacingAdd;
    }

    public TextLayoutBuilder setTextSpacingExtra(float spacingExtra) {
        if (this.mParams.spacingAdd != spacingExtra) {
            this.mParams.spacingAdd = spacingExtra;
            this.mSavedLayout = null;
        }
        return this;
    }

    public float getTextSpacingMultiplier() {
        return this.mParams.spacingMult;
    }

    public TextLayoutBuilder setTextSpacingMultiplier(float spacingMultiplier) {
        if (this.mParams.spacingMult != spacingMultiplier) {
            this.mParams.spacingMult = spacingMultiplier;
            this.mSavedLayout = null;
        }
        return this;
    }

    public boolean getIncludeFontPadding() {
        return this.mParams.includePadding;
    }

    public TextLayoutBuilder setIncludeFontPadding(boolean shouldInclude) {
        if (this.mParams.includePadding != shouldInclude) {
            this.mParams.includePadding = shouldInclude;
            this.mSavedLayout = null;
        }
        return this;
    }

    public Layout.Alignment getAlignment() {
        return this.mParams.alignment;
    }

    public TextLayoutBuilder setAlignment(Layout.Alignment alignment) {
        if (this.mParams.alignment != alignment) {
            this.mParams.alignment = alignment;
            this.mSavedLayout = null;
        }
        return this;
    }

    public TextDirectionHeuristicCompat getTextDirection() {
        return this.mParams.textDirection;
    }

    public TextLayoutBuilder setTextDirection(TextDirectionHeuristicCompat textDirection) {
        if (this.mParams.textDirection != textDirection) {
            this.mParams.textDirection = textDirection;
            this.mSavedLayout = null;
        }
        return this;
    }

    public TextLayoutBuilder setShadowLayer(float radius, float dx, float dy, @ColorInt int color) {
        this.mParams.createNewPaintIfNeeded();
        this.mParams.paint.setShadowLayer(radius, dx, dy, color);
        this.mSavedLayout = null;
        return this;
    }

    public TextLayoutBuilder setTextStyle(int style) {
        return this.setTypeface(Typeface.defaultFromStyle((int)style));
    }

    public Typeface getTypeface() {
        return this.mParams.paint.getTypeface();
    }

    public TextLayoutBuilder setTypeface(Typeface typeface) {
        if (this.mParams.paint.getTypeface() != typeface) {
            this.mParams.createNewPaintIfNeeded();
            this.mParams.paint.setTypeface(typeface);
            this.mSavedLayout = null;
        }
        return this;
    }

    public int[] getDrawableState() {
        return this.mParams.paint.drawableState;
    }

    public TextLayoutBuilder setDrawableState(int[] drawableState) {
        this.mParams.createNewPaintIfNeeded();
        this.mParams.paint.drawableState = drawableState;
        if (this.mParams.color != null && this.mParams.color.isStateful()) {
            int color = this.mParams.color.getColorForState(drawableState, 0);
            this.mParams.paint.setColor(color);
            this.mSavedLayout = null;
        }
        return this;
    }

    public TextUtils.TruncateAt getEllipsize() {
        return this.mParams.ellipsize;
    }

    public TextLayoutBuilder setEllipsize(TextUtils.TruncateAt ellipsize) {
        if (this.mParams.ellipsize != ellipsize) {
            this.mParams.ellipsize = ellipsize;
            this.mSavedLayout = null;
        }
        return this;
    }

    public boolean getSingleLine() {
        return this.mParams.singleLine;
    }

    public TextLayoutBuilder setSingleLine(boolean singleLine) {
        if (this.mParams.singleLine != singleLine) {
            this.mParams.singleLine = singleLine;
            this.mSavedLayout = null;
        }
        return this;
    }

    public int getMaxLines() {
        return this.mParams.maxLines;
    }

    public TextLayoutBuilder setMaxLines(int maxLines) {
        if (this.mParams.maxLines != maxLines) {
            this.mParams.maxLines = maxLines;
            this.mSavedLayout = null;
        }
        return this;
    }

    public boolean getShouldCacheLayout() {
        return this.mShouldCacheLayout;
    }

    public TextLayoutBuilder setShouldCacheLayout(boolean shouldCacheLayout) {
        this.mShouldCacheLayout = shouldCacheLayout;
        return this;
    }

    public boolean getShouldWarmText() {
        return this.mShouldWarmText;
    }

    public TextLayoutBuilder setShouldWarmText(boolean shouldWarmText) {
        this.mShouldWarmText = shouldWarmText;
        return this;
    }

    public GlyphWarmer getGlyphWarmer() {
        return this.mGlyphWarmer;
    }

    public TextLayoutBuilder setGlyphWarmer(GlyphWarmer glyphWarmer) {
        this.mGlyphWarmer = glyphWarmer;
        return this;
    }

    public Layout build() {
        BoringLayout layout;
        int width;
        int numLines;
        Layout cachedLayout;
        if (this.mShouldCacheLayout && this.mSavedLayout != null) {
            return this.mSavedLayout;
        }
        if (TextUtils.isEmpty((CharSequence)this.mParams.text)) {
            return null;
        }
        boolean hasClickableSpans = false;
        int hashCode = -1;
        if (this.mShouldCacheLayout && this.mParams.text instanceof Spannable) {
            ClickableSpan[] spans = (ClickableSpan[])((Spannable)this.mParams.text).getSpans(0, this.mParams.text.length() - 1, ClickableSpan.class);
            boolean bl = hasClickableSpans = spans.length > 0;
        }
        if (this.mShouldCacheLayout && !hasClickableSpans && (cachedLayout = (Layout)sCache.get((Object)(hashCode = this.mParams.hashCode()))) != null) {
            return cachedLayout;
        }
        BoringLayout.Metrics metrics = null;
        int n = numLines = this.mParams.singleLine ? 1 : this.mParams.maxLines;
        if (numLines == 1) {
            metrics = BoringLayout.isBoring((CharSequence)this.mParams.text, (TextPaint)this.mParams.paint);
        }
        switch (this.mParams.measureMode) {
            case 0: {
                width = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)this.mParams.text, (TextPaint)this.mParams.paint));
                break;
            }
            case 1: {
                width = this.mParams.width;
                break;
            }
            case 2: {
                width = Math.min((int)Math.ceil(Layout.getDesiredWidth((CharSequence)this.mParams.text, (TextPaint)this.mParams.paint)), this.mParams.width);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected measure mode " + this.mParams.measureMode);
            }
        }
        if (metrics != null) {
            layout = BoringLayout.make((CharSequence)this.mParams.text, (TextPaint)this.mParams.paint, (int)width, (Layout.Alignment)this.mParams.alignment, (float)this.mParams.spacingMult, (float)this.mParams.spacingAdd, (BoringLayout.Metrics)metrics, (boolean)this.mParams.includePadding, (TextUtils.TruncateAt)this.mParams.ellipsize, (int)width);
        } else {
            while (true) {
                try {
                    layout = StaticLayoutHelper.make(this.mParams.text, 0, this.mParams.text.length(), this.mParams.paint, width, this.mParams.alignment, this.mParams.spacingMult, this.mParams.spacingAdd, this.mParams.includePadding, this.mParams.ellipsize, width, numLines, this.mParams.textDirection);
                }
                catch (IndexOutOfBoundsException e) {
                    if (!(this.mParams.text instanceof String)) {
                        Log.e((String)"TextLayoutBuilder", (String)"Hit bug #35412, retrying with Spannables removed", (Throwable)e);
                        this.mParams.text = this.mParams.text.toString();
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        if (this.mShouldCacheLayout && !hasClickableSpans) {
            this.mSavedLayout = layout;
            sCache.put((Object)hashCode, (Object)layout);
        }
        this.mParams.mForceNewPaint = true;
        if (this.mShouldWarmText && this.mGlyphWarmer != null) {
            this.mGlyphWarmer.warmLayout((Layout)layout);
        }
        return layout;
    }

    private static class ComparableTextPaint
    extends TextPaint {
        private float mShadowDx;
        private float mShadowDy;
        private float mShadowRadius;
        private int mShadowColor;

        public ComparableTextPaint() {
        }

        public ComparableTextPaint(int flags) {
            super(flags);
        }

        public ComparableTextPaint(Paint p) {
            super(p);
        }

        public void setShadowLayer(float radius, float dx, float dy, int color) {
            this.mShadowRadius = radius;
            this.mShadowDx = dx;
            this.mShadowDy = dy;
            this.mShadowColor = color;
            super.setShadowLayer(radius, dx, dy, color);
        }

        public int hashCode() {
            Typeface tf = this.getTypeface();
            int hashCode = 1;
            hashCode = 31 * hashCode + this.getColor();
            hashCode = 31 * hashCode + Float.floatToIntBits(this.getTextSize());
            hashCode = 31 * hashCode + (tf != null ? tf.hashCode() : 0);
            hashCode = 31 * hashCode + Float.floatToIntBits(this.mShadowDx);
            hashCode = 31 * hashCode + Float.floatToIntBits(this.mShadowDy);
            hashCode = 31 * hashCode + Float.floatToIntBits(this.mShadowRadius);
            hashCode = 31 * hashCode + this.mShadowColor;
            hashCode = 31 * hashCode + this.linkColor;
            if (this.drawableState == null) {
                hashCode = 31 * hashCode + 0;
            } else {
                for (int i = 0; i < this.drawableState.length; ++i) {
                    hashCode = 31 * hashCode + this.drawableState[i];
                }
            }
            return hashCode;
        }
    }

    @VisibleForTesting
    static class Params {
        TextPaint paint = new ComparableTextPaint(1);
        int width;
        int measureMode;
        CharSequence text;
        ColorStateList color;
        float spacingMult = 1.0f;
        float spacingAdd = 0.0f;
        boolean includePadding = true;
        TextUtils.TruncateAt ellipsize = null;
        boolean singleLine = false;
        int maxLines = Integer.MAX_VALUE;
        Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
        TextDirectionHeuristicCompat textDirection = TextDirectionHeuristicsCompat.FIRSTSTRONG_LTR;
        boolean mForceNewPaint = false;

        Params() {
        }

        void createNewPaintIfNeeded() {
            if (this.mForceNewPaint) {
                this.paint = new ComparableTextPaint((Paint)this.paint);
                this.mForceNewPaint = false;
            }
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + (this.paint != null ? this.paint.hashCode() : 0);
            hashCode = 31 * hashCode + this.width;
            hashCode = 31 * hashCode + this.measureMode;
            hashCode = 31 * hashCode + Float.floatToIntBits(this.spacingMult);
            hashCode = 31 * hashCode + Float.floatToIntBits(this.spacingAdd);
            hashCode = 31 * hashCode + (this.includePadding ? 1 : 0);
            hashCode = 31 * hashCode + (this.ellipsize != null ? this.ellipsize.hashCode() : 0);
            hashCode = 31 * hashCode + (this.singleLine ? 1 : 0);
            hashCode = 31 * hashCode + this.maxLines;
            hashCode = 31 * hashCode + (this.alignment != null ? this.alignment.hashCode() : 0);
            hashCode = 31 * hashCode + (this.textDirection != null ? this.textDirection.hashCode() : 0);
            hashCode = 31 * hashCode + (this.text != null ? this.text.hashCode() : 0);
            return hashCode;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasureMode {
    }
}

