package com.eni.android.views.personalized;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class MyCustomView extends View {

	private Paint textPaint;
	private Bitmap bitmap;
	
	public MyCustomView(Context context) {
		super(context);
		init();
	}

	public MyCustomView(Context context, AttributeSet attrs) {
		super(context, attrs);
		init();
	}
	
	private void init() {
		Resources res = getResources();
		
		textPaint = new Paint(Paint.ANTI_ALIAS_FLAG);
		textPaint.setColor(res.getColor(R.color.button_text));
		textPaint.setTextSize(25);
		
		bitmap = BitmapFactory.decodeResource(getResources(),
                R.drawable.ic_launcher);

	}

	@Override
	protected void onDraw(Canvas canvas) {
		super.onDraw(canvas);
		canvas.drawBitmap(bitmap, 130, 10, null);
		canvas.rotate(90);
		canvas.drawText(getResources().getString(R.string.verticalText), 0, 0, textPaint);
		canvas.save();
	}
	

}
