package com.eni.android.rotation;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.widget.EditText;

public class RotacionManualEjemploActivity extends Activity {

	private static final String EMAIL = "EMAIL";
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.rotacion_manual_ejemplo, menu);
		return true;
	}

	@Override
	protected void onSaveInstanceState(Bundle outState) {
		super.onSaveInstanceState(outState);
		EditText email = (EditText) findViewById(R.id.email);
		String emailTxt = email.getText().toString();
		outState.putString(EMAIL, emailTxt);
	}

	@Override
	protected void onRestoreInstanceState(Bundle savedInstanceState) {
		super.onRestoreInstanceState(savedInstanceState);
		EditText email = (EditText) findViewById(R.id.email);
		email.setText(savedInstanceState.getString(EMAIL));
	}
}
