package com.eni.android.notifications;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.RemoteViews;

public class CustomNotification extends Activity {

	private static int NOTIFICATION_ID = 0;
	private final static int REQUEST_CODE = 0;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		Button addNotification = (Button) findViewById(R.id.addNotification);
		addNotification.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				createNotification();
			}
		});
	}

	protected void createNotification() {
		final NotificationManager mNotification = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);

		RemoteViews contentView = new RemoteViews(getPackageName(),
				R.layout.custom_notification);
		contentView.setImageViewResource(R.id.img, R.drawable.ic_launcher);
		contentView.setTextViewText(R.id.txt,
				getResources().getString(R.string.custom_notification));
		contentView.setImageViewResource(R.id.img2, R.drawable.play);
		

		final PendingIntent pendingIntent = PendingIntent.getActivity(this,
				REQUEST_CODE, new Intent(this,
						CustomNotification.class),
				PendingIntent.FLAG_ONE_SHOT);

		Notification.Builder builder = new Notification.Builder(this)
				.setSmallIcon(R.drawable.notification_icon)
				.setTicker(
						getResources().getString(
								R.string.notification_launching_title))
				.setWhen(System.currentTimeMillis())
				.setContentTitle(
						getResources().getString(R.string.notification_title))
				.setContentText(
						getResources().getString(R.string.notification_desc))
				.setContentIntent(pendingIntent).setContent(contentView);

		mNotification.notify(NOTIFICATION_ID, builder.getNotification());
	}
}
