package com.eni.android.parcelableejemplo;

import android.os.Parcel;
import android.os.Parcelable;

public class User implements Parcelable
{
	private String username;
	private String password;
	
	public User(String username, String password)
	{
		super();
		this.username = username;
		this.password = password;
	}

	public User(Parcel source)
	{
		this.username = source.readString();
		this.password = source.readString();
	}

	@Override
	public int describeContents() {
		return 0;
	}
	
	public static final Parcelable.Creator<User> CREATOR = new Parcelable.Creator<User>() {

		@Override
		public User createFromParcel(Parcel source) {
			return new User(source);
		}

		@Override
		public User[] newArray(int size) {
			return new User[size];
		}
	};

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(username);
		dest.writeString(password);		
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}
	
	
}