package com.eni.android.accion;

import java.io.File;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.widget.Toast;

public class EncontrarAccionEjemplo extends Activity {
	private static final String APPLICATION_PDF = "application/pdf";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		File externalDirectory = Environment.getExternalStorageDirectory();
		if (externalDirectory.canRead()) {
			String fileName = "/ejemplo.pdf";
			String pathFile = externalDirectory.getAbsoluteFile() + fileName;
			File file = new File(pathFile);

			if (file.exists()) {
				Uri path = Uri.fromFile(file);
				Intent intent = new Intent(Intent.ACTION_VIEW);
				intent.setDataAndType(path, APPLICATION_PDF);

				PackageManager pm = getPackageManager();
				ComponentName component = intent.resolveActivity(pm);
				
				if (component == null) {
					Toast.makeText(EncontrarAccionEjemplo.this,
							R.string.no_app_pdf,
							Toast.LENGTH_SHORT).show();
				} else {
					startActivity(intent);
				}
			}
		}
	}
}
