package com.eni.android.clicklistenermethod2ejemplo;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class ClickListenerMethod2Activity extends Activity implements OnClickListener {

	private static final String CLICK_LISTENER = "ClickListener";

	/**
	 * La clase implementa la interfaz OnClickListener
	 */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button btn1 = (Button) findViewById(R.id.btn1);
		btn1.setOnClickListener(this);

		Button btn2 = (Button) findViewById(R.id.btn2);
		btn2.setOnClickListener(this);
	}

	@Override
	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.btn1:
			Log.v(CLICK_LISTENER, getString(R.string.int_btn1));
			break;
		case R.id.btn2:
			Log.v(CLICK_LISTENER, getString(R.string.int_btn2));
			break;
		default:
			break;
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.click_listener_method2, menu);
		return true;
	}

}
