package com.eni.android.actionbarejemplo;

import android.app.ActionBar;
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;

public class ActionBarEjemplo extends Activity {

	private static final String ACTION_BAR_EXEMPLE_ACTIVITY = "ActionBarExempleActivity";

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
	}

	/**
	 * Creation de l'ActionBar
	 */
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.actionbar, menu);
		ActionBar actionBar = getActionBar();
		actionBar.setDisplayHomeAsUpEnabled(true);
		return true;
	}

	/**
	 * Gestion du clic sur l'ActionBar
	 */
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case R.id.menu_exit:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.boton_salir_clic));
			return true;
		case R.id.menu_help:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.boton_ayuda_clic));
			return true;
		case R.id.menu_link:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.boton_enlaces_clic));
			return true;
		case R.id.menu_search:
			Log.v(ACTION_BAR_EXEMPLE_ACTIVITY, getString(R.string.boton_buscar_clic));
			return true;
		}
		return super.onOptionsItemSelected(item);
	}

}
