package com.eni.android.nfc;

import android.app.Activity;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcAdapter.CreateNdefMessageCallback;
import android.nfc.NfcEvent;
import android.os.Bundle;
import android.os.Parcelable;

public class NFCActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		
		final String nfcAction = NfcAdapter.ACTION_NDEF_DISCOVERED;
		String action = getIntent().getAction();
		
		if (action.equals(nfcAction)) {
			Parcelable[] nfcTagMsg = getIntent().getParcelableArrayExtra(NfcAdapter.EXTRA_NDEF_MESSAGES);
			
			for (Parcelable nfcTag : nfcTagMsg) {
				NdefMessage msg = (NdefMessage) nfcTag;
				NdefRecord[] records = msg.getRecords();
				
				for (NdefRecord record : records) {
					//realizar los tratamientos en los diferentes campos que componen el tag NFC
				}
			}
		}
		
		NfcAdapter nfcAdapter = NfcAdapter.getDefaultAdapter(this);
		
		nfcAdapter.setNdefPushMessageCallback(new CreateNdefMessageCallback() {
			
			@Override
			public NdefMessage createNdefMessage(NfcEvent event) {
				//Crear su NdefMessage
				return null;
			}
		}, this);
		
	}
	
}
