package com.eni.android.sensor;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.TextView;

public class SensorActivity extends Activity {

	private int sensorType = Sensor.TYPE_ACCELEROMETER;
	
	private TextView xTextView;
	private TextView yTextView;
	private TextView zTextView;
	
	private float xAxis = 0f;
	private float yAxis = 0f;
	private float zAxis = 0f;
	
	private final SensorEventListener accelerometreEventListener = new SensorEventListener() {
		@Override
		public void onSensorChanged(SensorEvent event) {
			if (event.sensor.getType() == Sensor.TYPE_ACCELEROMETER) {
				xAxis = event.values[0];
				yAxis = event.values[1];
				zAxis = event.values[2];
				xTextView.setText("Eje x = " + Float.toString(xAxis));
				yTextView.setText("Eje y = " + Float.toString(yAxis));
				zTextView.setText("Eje z = " + Float.toString(zAxis));
			}
		}
		
		@Override
		public void onAccuracyChanged(Sensor sensor, int accuracy) {
			
		}
	};
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.acelerometro);

		xTextView = (TextView) findViewById(R.id.x_axis);
		yTextView = (TextView) findViewById(R.id.y_axis);
		zTextView = (TextView) findViewById(R.id.z_axis);
		
		final SensorManager sensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		sensorManager.registerListener(accelerometreEventListener, sensorManager.getDefaultSensor(sensorType), SensorManager.SENSOR_DELAY_NORMAL);		
	}
}
