package com.eni.android.data;

import android.app.Activity;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.view.Menu;
import android.widget.Toast;

public class Cap14_EstadoConectividadDatosEjemplo extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		/**
		 * Creación del listener sobre el estado de la conectividad de un dispositivo (excepto wifi)
		 */
		PhoneStateListener dataState = new PhoneStateListener() {
			@Override
			public void onDataConnectionStateChanged(int state) {
				switch (state) {
				case TelephonyManager.DATA_CONNECTED:
					Toast.makeText(Cap14_EstadoConectividadDatosEjemplo.this, R.string.dispositivo_conectado, Toast.LENGTH_LONG).show();
					break;
				case TelephonyManager.DATA_CONNECTING:
					Toast.makeText(Cap14_EstadoConectividadDatosEjemplo.this, R.string.dispositivo_conectandose, Toast.LENGTH_LONG).show();
					break;
				case TelephonyManager.DATA_DISCONNECTED:
					Toast.makeText(Cap14_EstadoConectividadDatosEjemplo.this, R.string.dispositivo_desconectado, Toast.LENGTH_LONG).show();
					break;
				case TelephonyManager.DATA_SUSPENDED:
					Toast.makeText(Cap14_EstadoConectividadDatosEjemplo.this, R.string.dispositivo_conectado_pero_tranferencia_datos_no_disponible, Toast.LENGTH_LONG).show();
					break;
				}
				super.onDataConnectionStateChanged(state);
			}
		};

		/**
		 * Añadir listener
		 */
		TelephonyManager tm = (TelephonyManager) getSystemService(TELEPHONY_SERVICE);
		tm.listen(dataState, PhoneStateListener.LISTEN_DATA_CONNECTION_STATE);

		/**
		 * Recuperación de un ConnectivityManager
		 */
		ConnectivityManager cm = (ConnectivityManager) getSystemService(CONNECTIVITY_SERVICE);
		NetworkInfo networkInfo = cm.getActiveNetworkInfo();
		boolean isConnected = false;
		if (networkInfo != null && networkInfo.isConnectedOrConnecting())
			isConnected = true;
		Toast.makeText(Cap14_EstadoConectividadDatosEjemplo.this, "is connected = " + isConnected, Toast.LENGTH_LONG).show();
		
		/**
		 * Comprobar si la conexión corresponde a una conexión WiFi
		 */
		boolean isWifi = false;
		if (networkInfo != null && networkInfo.getType() == ConnectivityManager.TYPE_WIFI)
			isWifi = true;
		Toast.makeText(Cap14_EstadoConectividadDatosEjemplo.this, "is wifi = " + isWifi, Toast.LENGTH_LONG).show();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(
				R.menu.cap14__estado_conectividad_datos_ejemplo, menu);
		return true;
	}

}
