package com.eni.android.map;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.widget.Toast;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.MyLocationOverlay;


public class GoogleMapsEjemploActivity extends MapActivity implements
		LocationListener {

	private MapView mapView;

	private MapController mapController;

	private LocationManager locationManager;

	private double lat = 0;
	private double lng = 0;
	private GeoPoint p;
	
	private MyLocationOverlay myLocation;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		mapView = (MapView) findViewById(R.id.map);
		mapView.setBuiltInZoomControls(true);
		mapController = mapView.getController();
		mapController.setZoom(17);

		locationManager = (LocationManager) getSystemService(LOCATION_SERVICE);
		locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER,
				10000, 0, this);
		locationManager.requestLocationUpdates(
				LocationManager.NETWORK_PROVIDER, 10000, 0, this);
		
		myLocation = new MyLocationOverlay(this, mapView);
		myLocation.enableMyLocation();
		mapView.getOverlays().add(myLocation);
	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	@Override
	public void onLocationChanged(Location location) {
		lat = location.getLatitude();
		lng = location.getLongitude();
		Toast.makeText(
				getBaseContext(),
				"Location change to: Latitude = " + lat + " Longitude = "
						+ lng, Toast.LENGTH_SHORT).show();
		
		p = new GeoPoint((int) (lat * 1E6), (int) (lng * 1E6));
		mapController.animateTo(p);
		mapController.setCenter(p);
	}

	@Override
	public void onProviderDisabled(String provider) {
		if (LocationManager.GPS_PROVIDER.equals(provider)) {
			Toast.makeText(this, "GPS provider disabled", Toast.LENGTH_SHORT).show();
		} else if (LocationManager.NETWORK_PROVIDER.equals(provider)) {
			Toast.makeText(this, "Network provider disabled", Toast.LENGTH_SHORT).show();
		} else {
			Toast.makeText(this, "other provider disabled = " + provider, Toast.LENGTH_SHORT).show();
		}
	}

	@Override
	public void onProviderEnabled(String provider) {
		if (LocationManager.GPS_PROVIDER.equals(provider)) {
			Toast.makeText(this, "GPS provider enabled", Toast.LENGTH_SHORT).show();
		} else if (LocationManager.NETWORK_PROVIDER.equals(provider)) {
			Toast.makeText(this, "Network provider enabled", Toast.LENGTH_SHORT).show();
		} else {
			Toast.makeText(this, "other provider enabled = " + provider, Toast.LENGTH_SHORT).show();
		}
	}

	@Override
	public void onStatusChanged(String provider, int status, Bundle extras) {
		if (status == LocationProvider.AVAILABLE) {
			Toast.makeText(this, "The provider " + provider + " is now available", Toast.LENGTH_SHORT).show();			
		} else if (status == LocationProvider.OUT_OF_SERVICE) {
			Toast.makeText(this, "The provider " + provider + " is out of service", Toast.LENGTH_SHORT).show();			
		} else if (status == LocationProvider.TEMPORARILY_UNAVAILABLE) {
			Toast.makeText(this, "The provider " + provider + " is temporarily unavailable", Toast.LENGTH_SHORT).show();			
		}
	}
	
	@Override
	protected void onStop() {
		super.onStop();
		locationManager.removeUpdates(this);
	}

}