package com.eni.android.map;

import android.os.Bundle;
import android.view.KeyEvent;

import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;

public class Cap13_GoogleMapsEjemploActivity extends MapActivity {

	private MapView mapView;

	private MapController mapController;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		mapView = (MapView) findViewById(R.id.map);

		// Añadir botones de zoom
		mapView.setBuiltInZoomControls(true);

		// Inicialización del controlador del mapa
		mapController = mapView.getController();

		// Inicialización del valor por defecto del zoom
		mapController.setZoom(17);
		
	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
			mapView.setSatellite(true);
			return true;
		} else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
			mapView.setSatellite(false);
			return true;
		} 
		return super.onKeyDown(keyCode, event);
	}

}