package com.eni.android.map;

import android.os.Bundle;
import android.view.KeyEvent;

import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.OverlayItem;

public class Cap13_GoogleMapEjemploActivity extends MapActivity {

	private MapView mapView;

	private MapController mapController;

	private ListaMarcadores overlays;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		mapView = (MapView) findViewById(R.id.map);
		mapView.setBuiltInZoomControls(true);
		mapController = mapView.getController();
		mapController.setZoom(17);

		overlays = new ListaMarcadores(getResources().getDrawable(
				R.drawable.ic_launcher), this);

		int latitude = (int) (2.294769287109375 * 1E6);
		int longitude = (int) (48.85782582717226 * 1E6);

		GeoPoint geoPoint = new GeoPoint(longitude, latitude);
		OverlayItem overlayitem = new OverlayItem(geoPoint,
				getString(R.string.mi_primer_marcador), getString(R.string.aqui_mi_primer_marcador));
		overlays.addItemToOverlayList(overlayitem);
		mapView.getOverlays().add(overlays);

		mapController.animateTo(geoPoint);
		mapController.setCenter(geoPoint);

	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
			mapView.setSatellite(true);
			return true;
		} else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
			mapView.setSatellite(false);
			return true;
		}
		return super.onKeyDown(keyCode, event);
	}

}