package com.eni.android.alarma;

import java.util.Calendar;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class MyCustomAlarm extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		Button launch = (Button) findViewById(R.id.launchMap);
		launch.setOnClickListener(new OnClickListener() {

			@Override
			public void onClick(View v) {
				/**
				 * En este ejemplo, el servicio se creará 30 segundos después
				 * de pulsar el botón de la interfaz
				 */
				Intent serviceIntent = new Intent(MyCustomAlarm.this,
						MyAlarmService.class);
				PendingIntent pendingIntent = PendingIntent.getService(
						MyCustomAlarm.this, 0, serviceIntent, 0);
				/**
				 * Obtención del AlarmManager
				 */
				AlarmManager am = (AlarmManager) getSystemService(ALARM_SERVICE);
				/**
				 * Especificación de un tiempo de disparo
				 */
				Calendar calendar = Calendar.getInstance();
				calendar.setTimeInMillis(System.currentTimeMillis());
				calendar.add(Calendar.SECOND, 30);
				/**
				 * Añadir una nueva alarma
				 */
				am.set(AlarmManager.RTC_WAKEUP, calendar.getTimeInMillis(),
						pendingIntent);
			}
		});

	}

}
