package com.eni.android.database;

import android.app.Activity;
import android.content.ContentValues;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.widget.Toast;

public class ContentProviderEjemploActivity extends Activity {
	
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		insertRecords();
		displayContentProvider();
	}

	private void displayContentProvider() {
		String columns[] = new String[] { CapituloBBDD.COL_ID,
				CapituloBBDD.COL_NAME, CapituloBBDD.COL_DESC };
		Uri mContacts = CapituloContentProvider.contentUri;
		Cursor cur = getContentResolver().query(mContacts, columns, null, null,
				null);

		if (cur.moveToFirst()) {
			String name = null;
			do {
				name = cur.getString(cur.getColumnIndex(CapituloBBDD.COL_ID))
						+ " "
						+ cur.getString(cur
								.getColumnIndex(CapituloBBDD.COL_NAME))
						+ " "
						+ cur.getString(cur
								.getColumnIndex(CapituloBBDD.COL_DESC));
				Toast.makeText(this, name + " ", Toast.LENGTH_LONG).show();
			} while (cur.moveToNext());
		}
	}

	private void insertRecords() {
		ContentValues contact = new ContentValues();
		contact.put(CapituloBBDD.COL_NAME, getString(R.string.capitulo_1));
		contact.put(CapituloBBDD.COL_DESC,
				getString(R.string.presentacion_de_la_plataforma_android));
		getContentResolver()
				.insert(CapituloContentProvider.contentUri, contact);

		contact.clear();
		contact.put(CapituloBBDD.COL_NAME, getString(R.string.capitulo_2));
		contact.put(CapituloBBDD.COL_DESC, getString(R.string.entorno_de_desarrollo));
		getContentResolver()
				.insert(CapituloContentProvider.contentUri, contact);

		contact.clear();
		contact.put(CapituloBBDD.COL_NAME, getString(R.string.capitulo_3));
		contact.put(CapituloBBDD.COL_DESC,
				getString(R.string.principios_de_programacion_en_android));
		getContentResolver()
				.insert(CapituloContentProvider.contentUri, contact);
	}
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.content_priveder_ejemplo, menu);
		return true;
	}

}
