package com.eni.android.database;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;

public class CapituloBaseSQLite extends SQLiteOpenHelper {

	private static final String TABLA_CAPITULOS = "tabla_capitulos";
	private static final String COL_ID = "ID";
	private static final String COL_NAME = "NAME";
	private static final String COL_DESC = "DESCRIPTION";
	
	private static final String CREATE_BDD = "CREATE TABLE " + TABLA_CAPITULOS + " (" + 
	COL_ID + " INTEGER PRIMARY KEY AUTOINCREMENT, " + COL_NAME + " TEXT NOT NULL, " +
	COL_DESC + " TEXT NOT NULL);";		
	
	public CapituloBaseSQLite(Context context, String name, CursorFactory factory, int version) {
		super (context, name, factory, version);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL(CREATE_BDD);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		//En este método, debe gestionar los incrementos de versión de su base de datos
		db.execSQL("DROP TABLE " + TABLA_CAPITULOS);
		onCreate(db);
	}
	

}
