package com.eni.android.map;

import android.os.Bundle;
import android.view.KeyEvent;

import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;

public class Ch13_GoogleMapExempleActivity extends MapActivity {

	private MyGoogleMap mapView;

	private MapController mapController;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		mapView = (MyGoogleMap) findViewById(R.id.map);

		// Ajout des boutons de zoom
		mapView.setBuiltInZoomControls(true);

		// Initialisation du controleur de la map
		mapController = mapView.getController();

		// Initialisation de la valeur par dfaut du zoom
		mapController.setZoom(17);

	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_VOLUME_UP) {
			mapView.setSatellite(true);
			return true;
		} else if (keyCode == KeyEvent.KEYCODE_VOLUME_DOWN) {
			mapView.setSatellite(false);
			return true;
		}
		return super.onKeyDown(keyCode, event);
	}

}