package com.eni.android.sharedPref;

import android.app.Activity;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.view.Menu;

public class SharedPreferencesEjemploActivity extends Activity {

	private String SHARED_KEY = "mysharedkey";

	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		

		SharedPreferences myPref = getPreferences(MODE_PRIVATE);
		SharedPreferences.Editor editor = myPref.edit();
		editor.putBoolean(SHARED_KEY, true);
		editor.commit();

		@SuppressWarnings("unused")
		boolean myValue = myPref.getBoolean(SHARED_KEY, false);

		myPref.registerOnSharedPreferenceChangeListener(new OnSharedPreferenceChangeListener() {
			@Override
			public void onSharedPreferenceChanged(
					SharedPreferences sharedPreferences, String key) {
				// Verificar el sharedPreference y la clave
			}
		});

		editor.remove(SHARED_KEY);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.shared_preferences_ejemplo, menu);
		return true;
	}

}
