package com.eni.android.database;

import java.util.ArrayList;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class BaseDeDatosEjemploActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		
		ListView list = (ListView) findViewById(R.id.chapterList);
        
        Capitulo chapitre1 = new Capitulo(getString(R.string.la_plataforma_android), getString(R.string.presentacion_y_cronologia_de_la_plataforma_android));
        Capitulo chapitre2 = new Capitulo(getString(R.string.entorno_de_desarrollo), getString(R.string.presentacion_e_instalacion_del_entorno_de_desarrollo_android));
        Capitulo chapitre3 = new Capitulo(getString(R.string.principios_de_programacion), getString(R.string.presentacion_de_las_caracteristicas_especificas_del_desarrollo_en_android));
        Capitulo chapitre4 = new Capitulo(getString(R.string.mi_primera_aplicacion_helloandroid), getString(R.string.creacion_del_primer_proyecto_android_y_explicacion_de_la_arquitectura_de_un_proyecto_android));
        Capitulo chapitre5 = new Capitulo(getString(R.string.depuracion_y_gestion_de_errores), getString(R.string.explicacion_de_la_forma_de_depurar_una_aplicacion_android));
        Capitulo chapitre6 = new Capitulo(getString(R.string.creacion_de_interfaces_sencillas), getString(R.string.introduccion_a_la_creacion_de_interfaces_en_android));

        CapituloBBDD capituloBbdd = new CapituloBBDD(this);
        capituloBbdd.openForWrite();
        capituloBbdd.insertChapter(chapitre1);
        capituloBbdd.insertChapter(chapitre2);
        capituloBbdd.insertChapter(chapitre3);
        capituloBbdd.insertChapter(chapitre4);
        capituloBbdd.insertChapter(chapitre5);
        capituloBbdd.insertChapter(chapitre6);
        
        ArrayList<Capitulo> chapterList = capituloBbdd.getAllChapters();
        capituloBbdd.close();
        ArrayAdapter<Capitulo> adapter = new ArrayAdapter<Capitulo>(this, android.R.layout.simple_list_item_1, chapterList);
        list.setAdapter(adapter);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.base_de_datos_ejemplo, menu);
		return true;
	}

}
