package com.eni.android.almacenamiento;

import java.io.File;

import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;
import android.view.Menu;

public class AlmacenamientoExternoEjemploActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);

		final String storageState = Environment.getExternalStorageState();

		if (storageState.equals(Environment.MEDIA_MOUNTED)) {
			//Puede leer y escribir en el almacenamiento externo
			@SuppressWarnings("unused")
			File outFile = getExternalFilesDir(Environment.DIRECTORY_DCIM);
		} else if (storageState.equals(Environment.MEDIA_MOUNTED_READ_ONLY)) {
			//Solamente puede eler del almacenamiento externo 
			@SuppressWarnings("unused")
			File sharedFile = Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM);
		} else if (storageState.equals(Environment.MEDIA_REMOVED)) {
			//El almacenamiento externo no está disponible
		} else {
			//Otros casos
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.almacenamiento_externo_ejemplo, menu);
		return true;
	}

}
