﻿# Further Reading
*For the book "Hands-On System Programming with Linux", Kaiwan N Billimoria, Packt (2018).*
![enter image description here](https://dz13w8afd47il.cloudfront.net/sites/default/files/imagecache/ppv4_main_book_cover/B09991_MockupCover_New.png)
Book GitHub repo: [https://github.com/PacktPublishing/Hands-on-System-Programming-with-Linux](https://github.com/PacktPublishing/Hands-on-System-Programming-with-Linux)

Here, we present, in a chapter-wise format, additional online as well as book references. We feel that these will help, you, the reader, in digging deeper into topics, or gaining additional views/information, or both. We definitely recommend you browse through the provided references. Also, you will find that some resources are repeated across chapters; we leave it this way so that the reader can gain all required resources in one place (and chapter-wise).
(Obviously, these reference articles/blogs/etc are provided "as-is"; we cannot vouch for their correctness or validity).

## Chapter 1, Linux System Architecture : Further Reading

 -  UNIX | History and Timeline: [http://www.​unix.org/what_is_unix/history_timeline.html](http://www.unix.org/what_is_unix/history_timeline.html)
 -  Unix-such as OSes: [https://en.wikipedia.org/wiki/Unix](https://en.wikipedia.org/wiki/Unix)
 - Low-Level Software Design : [https://kaiwantech.wordpress.com/2017/01/03/low-level-software-design/](https://kaiwantech.wordpress.com/2017/01/03/low-level-software-design/)
 - Application Binary Interface (ABI) docs and their meaning: [https://kaiwantech.wordpress.com/2018/05/07/application-binary-interface-abi-docs-and-their-meaning/](https://kaiwantech.wordpress.com/2018/05/07/application-binary-interface-abi-docs-and-their-meaning/)
 - Introduction to x64 assembly (Intel): [https://software.intel.com/sites/default/files/m/d/4/1/d/8/Introduction_to_x64_Assembly.pdf](https://software.intel.com/sites/default/files/m/d/4/1/d/8/Introduction_to_x64_Assembly.pdf)
 - Inline assembly – start from scratch (PPC): [https://www.ibm.com/developerworks/aix/library/au-inline_assembly/index.html](https://www.ibm.com/developerworks/aix/library/au-inline_assembly/index.html)
 - Intel® 64 and IA-32 Architectures Software Developer Manuals: [https://software.intel.com/en-us/articles/intel-sdm](https://software.intel.com/en-us/articles/intel-sdm)
 - CPU Rings, Privilege, and Protection: [https://manybutfinite.com/post/cpu-rings-privilege-and-protection/](https://manybutfinite.com/post/cpu-rings-privilege-and-protection/)
 - ARM Processors:
	 - The ARM University Program, ARM Architecture Fundamentals
video tutorial: [https://www.youtube.com/watch?v=7LqPJGnBPMM](https://www.youtube.com/watch?v=7LqPJGnBPMM)
	 - "Want to learn more about Arm's Cortex-A series of processors?",
Linaro (Aarch32): [https://www.linaro.org/blog/want-to-learn-more-about-arms-cortex-a-series-of-processors/](https://www.linaro.org/blog/want-to-learn-more-about-arms-cortex-a-series-of-processors/)
	 - "Aarch64 : ARM Cortex-A Series Programmer's Guide for ARMv8A" : [https://developer.arm.com/docs/den0024/latest/preface](https://developer.arm.com/docs/den0024/latest/preface)
 - System call, Wikipedia: [https://en.wikipedia.org/wiki/System_call](https://en.wikipedia.org/wiki/System_call)
 - Implementing Linux system Calls [LJ, Dec ‘99]: [https://www.linuxjournal.com/article/3326](https://www.linuxjournal.com/article/3326)
 - Monolithic kernel, Wikipedia: [https://en.wikipedia.org/wiki/Monolithic_kernel](https://en.wikipedia.org/wiki/Monolithic_kernel)
 - Microkernel, Wikipedia: [https://en.wikipedia.org/wiki/Microkernel](https://en.wikipedia.org/wiki/Microkernel)
 - Hybrid kernel, Wikipedia: [https://en.wikipedia.org/wiki/Hybrid_kernel](https://en.wikipedia.org/wiki/Hybrid_kernel)

*Books*
 - The Art of Unix Programming, Eric S Raymond (AW)
 - The Mythical Man Month, Frederick P Brooks
 - Programming Pearls, Jon Bentley
 - The Practice of Programming, Brian Kernighan and Rob Pike
 - The Joy of Linux, Hall and Proffitt

## Chapter 2, Virtual Memory : Further Reading
- Debugging with GDB, Sourceware (the GDB Manual): [https://sourceware.org/gdb/current/onlinedocs/gdb/](https://sourceware.org/gdb/current/onlinedocs/gdb/)
- The man page on the core(5) file: [https://linux.die.net/man/5/core](https://linux.die.net/man/5/core)

*Books*
- 'Operating System Concepts', Silberschatz, Galvin and Gagne, 9th Ed.
- 'Understanding the Linux Virtual Memory Manager', Mel Gorman (a bit old now (July 2007), but extensive - and many areas still relevant - in-depth coverage of Linux memory internals); PDF: 
[https://www.kernel.org/doc/gorman/pdf/understand.pdf](https://www.kernel.org/doc/gorman/pdf/understand.pdf)

*(Ch 3, Resource Limits : Further Reading : \<none\>)*

## Chapter 4, Dynamic Memory Allocation : Further Reading

- Blog article: 'Understanding glibc malloc internals' :
[https://sploitfun.wordpress.com/2015/02/10/understanding-glibc-malloc/](https://sploitfun.wordpress.com/2015/02/10/understanding-glibc-malloc/)
- 'Allocating memory objects with strict alignment requirements'; within the CMU SEI CERT C Coding Standard [[https://wiki.sei.cmu.edu/confluence/display/c/SEI+CERT+C+Coding+Standard]](https://wiki.sei.cmu.edu/confluence/display/c/SEI+CERT+C+Coding+Standard), the page '*MEM36-C. Do not modify the alignment of objects by calling realloc()'* : [https://wiki.sei.cmu.edu/confluence/pages/viewpage.action?pageId=87152255](https://wiki.sei.cmu.edu/confluence/pages/viewpage.action?pageId=87152255)
- InfoSec: Stack Overflow / Stack Smashing / BoF attacks
	- 'How security flaws work: The buffer overflow' :
[https://arstechnica.com/information-technology/2015/08/how-security-flaws-work-the-buffer-overflow/](https://arstechnica.com/information-technology/2015/08/how-security-flaws-work-the-buffer-overflow/)
	- The Morris Worm: [https://en.wikipedia.org/wiki/Morris_worm](https://en.wikipedia.org/wiki/Morris_worm)
- Linux kernel Out Of Memory (OOM) killer
	- 'When the Kernel Runs Out of Memory', Google @ LinuxCon 2010 : [https://events.static.linuxfound.org/slides/2010/linuxcon2010_rientjes.pdf](https://events.static.linuxfound.org/slides/2010/linuxcon2010_rientjes.pdf)
	- 'What are the disadvantages of disabling memory overcommit in
Linux?' : [https://www.quora.com/What-are-the-disadvantages-of-disabling-memory-overcommit-in-Linux](https://www.quora.com/What-are-the-disadvantages-of-disabling-memory-overcommit-in-Linux)
- Emulate an ARM-32 running embedded Linux easily with the *SEALS (Simple Embedded ARM Linux System)* project: [https://github.com/kaiwan/seals](https://github.com/kaiwan/seals)
- Kernel doc on Linux Security Modules (LSMs) Usage:
[https://www.kernel.org/doc/html/v4.16/admin-guide/LSM/index.html](https://www.kernel.org/doc/html/v4.16/admin-guide/LSM/index.html)
- Linux kernel tracing with Ftrace, three-part article on LWN (the first
is): 'Debugging the kernel using Ftrace - part 1': [https://lwn.net/Articles/365835/](https://lwn.net/Articles/365835/)

## Ch 5, Linux Memory Issues : Further Reading

- Undefined behavior
	- 'Undefined Behavior in 2017', Cuoq & Regehr: [https://blog.regehr.org/archives/1520](https://blog.regehr.org/archives/1520)
	- C Programming Language standards - the ISO/IEC 9899:201x
Committee Draft dated 02 Dec 2010 : [http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1548.pdf](http://www.open-std.org/jtc1/sc22/wg14/www/docs/n1548.pdf)
	- CWE-658 - 'Weaknesses in Software Written in C' : [https://cwe.mitre.org/data/definitions/658.html](https://cwe.mitre.org/data/definitions/658.html)
- InfoSec:
	- Heartbleed: [http://heartbleed.com/](http://heartbleed.com/)
	- A succinct comic-book explanation of the infamous
Heartbleed bug—a case of read overflow—on XKCD: [https://xkcd.com/1354/](https://xkcd.com/1354/)
	-	*A must-read*: 'How to Prevent the next Heartbleed', David Wheeler : [https://dwheeler.com/essays/heartbleed.html](https://dwheeler.com/essays/heartbleed.html)

## Ch 6, Debugging Tools for Memory Issues : Further Reading

- A list of static analysis tools for C and C++ : [https://en.wikipedia.org/wiki/List_of_tools_for_static_code_analysis#C,_C++](https://en.wikipedia.org/wiki/List_of_tools_for_static_code_analysis#C,_C++)
- This blog article offers an interesting comparison of some popular static
analysis tools (cppcheck, Clang-tidy) on a real-world open source codebase:
'Lots o' static' : [http://btorpey.github.io/blog/2017/09/17/lotso-static/](http://btorpey.github.io/blog/2017/09/17/lotso-static/)
- Shadow memory:
	- The kernel address sanitizer, LWN : [https://lwn.net/Articles/612153/](https://lwn.net/Articles/612153/)
	- AddressSanitizerAlgorithm : [https://github.com/google/sanitizers/wiki/AddressSanitizerAlgorithm](https://github.com/google/sanitizers/wiki/AddressSanitizerAlgorithm)
- ... security vulnerabilities that can be exploited when running ASan in
production : [https://seclists.org/oss-sec/2016/q1/363](https://seclists.org/oss-sec/2016/q1/363)

*Books*
*The Art of Debugging: with GDB, DDD and Eclipse*, Matloff and Salzman, No
Starch Press.

## Ch 7, Process Credentials and Ch 8, Process Capabilities : Further Reading

- InfoSec:
	- 'Security problems are just bugs', Linus Torvalds, LKML, 17 Nov
2017 : https://lkml.org/lkml/2017/11/17/767
	- 'Secure Programming HOWTO - Creating Secure Software', David Wheeler : https://www.dwheeler.com/secure-programs/
	- Wireshark Security page : https://wiki.wireshark.org/Security
and Security Advisories : https://www.wireshark.org/security/
	- Penetration Test (or pentesting); an article 'Penetration Testing: Assessing Your Overall Security Before Attackers Do', SANS Institute
- (Some) Linux Kernel Exploits
	- Interesting! 'A bunch of links related to Linux kernel
exploitation' : https://github.com/xairy/linux-kernel-exploitation
	- 'This is what a root debug backdoor in a Linux kernel
looks like', The Register : http://www.theregister.co.uk/2016/05/09/allwinners_allloser_custom_kernel_has_a_nasty_root_backdoor/
- Linux proc filesystem (CentOS) : https://www.centos.org/docs/5/html/Deployment_Guide-en-US/ch-proc.html

## Ch 9, Process Execution and Ch 10, Process Creation : Further Reading
- 'File locking in Linux' - a tutorial : https://gavv.github.io/blog/file-locks/

*Books*
- The classic text *Unix Network Programming*, W Richard Stevens
- *Unix Systems Programming: Communication, Concurrency and
Threads*, Robbins and Robbins
- Secure Programming for Linux and Unix HOWTO*, David Wheeler : https://www.tldp.org/HOWTO/pdf/Secure-Programs-HOWTO.pdf

## Ch 11, Signaling - Part I : Further Reading

- Glibc feature test macros, M Kerrisk, LWN, March, 2014 : https://lwn.net/Articles/590381/
- CPU ABI (Application Binary Interface) documentation, blog article : 
'APPLICATION BINARY INTERFACE (ABI) DOCS AND THEIR
MEANING' : https://kaiwantech.wordpress.com/2018/05/07/application-binary-interface-abi-docs-and-their-meaning/

## Ch 12, Signaling - Part II : Further Reading

- Process Groups and related information : https://www.win.tue.nl/~aeb/linux/lk/lk-10.html
- Tracing with LTTng
	- The LTTng Documentation : https://lttng.org/docs/v2.10/
	- Trace Compass GUI : https://www.eclipse.org/tracecompass/

## Ch 13, Timers : Further Reading
- 'Hrtimers and Beyond: Transforming the Linux Time Subsystems', Thomas
Gleixner and Douglas Niehaus (2006). This is an old but interesting
paper on the new timers and HRT implementation on 2.6 Linux : https://www.landley.net/kdocs/ols/2006/ols2006v1-pages-333-346.pdf
- Man page on the *librt* POSIX.1b—Realtime Extensions to POSIX
interfaces: https://www.unix.com/man-page/all/3LIB/librt/
- How Fast is Fast?
	- 'Latency Numbers Every Programmer Should Know' : https://gist.github.com/nvartolomei/2864150
	- CPU Caches animated demo: http://www.overbyte.com.au/misc/Lesson3/CacheFun.html
	- Average Human Reaction Times: https://backyardbrains.com/experiments/reactiontime
- Blog article: 'Using the Watchdog Timer in Linux' : https://www.jann.cc/2013/02/02/linux_watchdog.html


## Ch 14, Multithreading Part I - Essentials : Further Reading

- Perf
	- 'Linux Profiling at Netflix', Brendan Gregg : https://www.slideshare.net/brendangregg/scale2015-linux-perfprofiling
	- 'Linux Perf' : http://www.brendangregg.com/linuxperf.html
	- Tutorial: Linux kernel profiling with perf: https://perf.wiki.kernel.org/index.php/Tutorial
- A timeline of UNIX history: https://commons.wikimedia.org/wiki/File:Unix_history-simple.svg
- NGINX blog : 'Thread Pools in NGINX Boost Performance 9x!', June 2015: https://www.nginx.com/blog/thread-pools-boost-performance-9x/
- Threading models, an article: 'Threading models: So many different ways to get stuff done' : http://timetobleed.com/threading-models-so-many-different-ways-to-get-stuff-done/
- Stack size matters; read about this experience (you might need to scroll down to the answer starting with "My team inherited a CGI-based, multi-threaded C++ web app. The main platform was Windows; a distant, secondary platform was Solaris with Posix threads") : https://stackoverflow.com/questions/169713/whats-the-toughest-bug-you-ever-found-and-fixed#
- The GDB Debugger:
	- Beej's Quick Guide to GDB: http:/​/​beej.​us/​guide/​bggdb/​
	- Book: *The Art of Debugging with GDB, DDD, and Eclipse*,
Matloff and Salzman.

## Ch 15, Multithreading Part II - Synchronization : Further Reading

- 'Why Not to Share a Mutable State [Comic]',
Dzone: https://dzone.com/articles/why-not-to-share-a-mutable-state-comic?fromrel=true
- The Linux *Big Kernel Lock (BKL)* : https://kernelnewbies.org/BigKernelLock
- Quora: *The hardest part of programming, for me, is coming up with good variable names. What is a good solution around this problem?* :  https://www.quora.com/The-hardest-part-of-programming-for-me-is-coming-upwith-good-variable-names-What-is-a-good-solution-around-this-problem
- The Linux *futex*
	- 'Futex Cheat Sheet' : https://locklessinc.com/articles/futex_cheat_sheet/
	- A description of what robust futexes are :
https://www.kernel.org/doc/Documentation/robust-futexes.txt
- IPC - Inter Process Communication - Mechanisms
	- *Books*
		- *Unix Network Programming: Interprocess Communications - Vol.2 : Interprocess Communications*, W. Richard Stevens. A classic.
		- *The Linux Programming Interface – A Linux and UNIX System Programming Handbook*, M Kerrisk.
	- *Beej's Guide to UNIX IPC*, 'Beej' : http://beej.us/guide/bgipc/
- Watchdog Timer
	- Linux kernel documentation on Watchdog : https://www.kernel.org/doc/Documentation/watchdog/
	- 'Using the Watchdog Timer in Linux' : https://www.jann.cc/2013/02/02/linux_watchdog.html
- The Mars Pathfinder mission and Priority Inversion
	- 'What really happened on Mars ?' Glenn Reeves : https://cs.unc.edu/~anderson/teach/comp790/papers/mars_pathfinder_long_version.html
	- A must-read (PDF): *What the Media Couldn't Tell You About Mars Pathfinder* : http://people.cs.ksu.edu/~hatcliff/842/Docs/Course-Overview/pathfinder-robotmag.pdf
	- Detailed paper (PDF): *Mars Pathfinder: Priority Inversion Problem*, R.M. Pathan :  http://www.cse.chalmers.se/edu/year/2015/course/EDA222/Documents/Misc/Report_MarsPathFinder.pdf
	- More recently (May 2015), with respect to the NASA Curiosity Rover: *13 engineering truths proved by NASA's Curiosity Rover*, EDN :  https://www.edn.com/electronics-blogs/now-hear-this/4439386/13-engineering-truths-proved-by-NASA-s-CuriosityRover?mc=NL_EDN_EDT_EDN_funfriday_20150508&cid=NL_EDN_EDT_EDN_funfriday_20150508&elq=75871e4437784010b51f12e4c3be00a2&elqCampaignId=22919&elqaid=25798&elqat=1&elqTrackId=8e848e14bf3e41b58e660c804b335b07
- 'Helgrind: a thread error detector' : http://valgrind.org/docs/manual/hg-manual.html

## Ch 16, Multithreading Part III : Further Reading

- Stack Overflow Q&A— *Threadsafe vs re-entrant* : https://stackoverflow.com/questions/856823/threadsafe-vs-re-entrant
- Blog article: 'PTHREADS DEV – COMMON PROGRAMMING MISTAKES TO AVOID' : https://kaiwantech.wordpress.com/2018/09/21/pthreads-devcommon-programming-mistakes-to-avoid/
- Thread-Local Storage (TLS)
	- GCC page on *Thread-Local Storage* : https://gcc.gnu.org/onlinedocs/gcc/Thread-Local.html
	- Linux's thread-local storage implementation: https://stackoverflow.com/questions/2459692/linuxs-thread-local-storage-implementation
- Using *Thread-Specific Data (TSD)* : http://elias.rhi.hi.is/libc/Thread-Specific-Data.html
- A list of cancellation points (APIs) from the Open Group POSIX.1c
documentation on threads (scroll down to the section on *Cancellation Points*
) : http://pubs.opengroup.org/onlinepubs/009695399/functions/xsh_chap02_09.html
- Debugging Races in pthreads applications
	- With *Helgrind* : http://valgrind.org/docs/manual/hg-manual.html
	- (Modern) TSan (Thread Sanitizer, part of the Sanitizer toolset we  mentioned in *Chapter 6, Debugging Tools for Memory Issues*) : https://github.com/google/sanitizers/wiki/AddressSanitizer
- Blog article: 'Threads and fork(): think twice before mixing them' : http://www.linuxprogrammingblog.com/threads-and-fork-think-twice-before-using-them
- *Books*
	-  *Programming with POSIX Threads*, David R. Butenhof
	- *Multithreaded Programming with Pthreads*, Bil Lewis and Daniel J. Berg.

## Ch 17, CPU Scheduling : Further Reading

- *VDC Survey on real-time response* : The Embedded Muse, 341, 03 Jan 2018, Jack Ganssle: http://www.ganssle.com/tem/tem341.html#article3
- Blog article: 'Algorithm time complexity and big O notation' : https://medium.com/@StueyGK/algorithm-time-complexity-and-big-o-notation-51502e612b4d
- Book: *Automate This: How Algorithms Came to Rule Our World*, Christopher
Steiner 
- *RTL – Real-Time Linux*, using Linux as an RTOS:
	- The RTL Collaborative Project: https://wiki.linuxfoundation.org/realtime/rtl/start
	- RTL Real-Time documentation: https://wiki.linuxfoundation.org/realtime/documentation/start
	- *HOWTO: RTOS and RT Applications* : https://wiki.linuxfoundation.org/realtime/documentation/howto/applications/application_base
	- *Intro to Real-Time Linux for Embedded Developers* : interview with Steven Rostedt: https://www.linuxfoundation.org/blog/2013/03/intro-to-real-time-linux-for-embedded-developers/


## Ch 18, Advanced File I/O : Further Reading

- A collection of useful CLI (command line interface) wrapper utilities
called *linux-ftools* is available on github here : https://github.com/david415/linux-ftools. It provides the fincore(1) (that's to be read as "f-in-core"), fadvise(1) and fallocate(1) utilities; do check out their GitHub README and try them out
- Using the controversial *goto* for error handling within the Linux kernel
codebase:
	- https://www.kernel.org/doc/html/v4.10/process/coding-style.html#centralized-exiting-of-functions
	- http://koblents.com/Ches/Links/Month-Mar-2013/20-Using-Goto-in-Linux-Kernel-Code/
- Blog article: 'Page Cache, the Affair Between Memory and Files' : https://manybutfinite.com/post/page-cache-the-affair-between-memory-and-files/
- The Linux IO stack - a more detailed view (see the diagram on page 2, *1.1 The Linux I/O Stack*) : https://www.tau.ac.il/~stoledo/BudilovskyMScThesis.pdf
- Zero-Copy Technique (particularly on using the sendfile(2) syscall):
	- Article: *Efficient data transfer through zero copy; Zero copy, zero overhead*, IBM DeveloperWorks : https://www.ibm.com/developerworks/library/j-zerocopy/index.html
	- Article: *Zero Copy I: User-Mode Perspective*, LJ : https://www.linuxjournal.com/article/6345
- IO Schedulers
	- From the ArchLinux wiki : https://wiki.archlinux.org/index.php/improving_performance#Input.2Foutput_schedulers
	- BFQ (Budget Fair Queuing) Documentation: https://github.com/torvalds/linux/blob/master/Documentation/block/bfq-iosched.txt
- Blog article: 'Async IO on Linux: select, poll and epoll', Julia Evans : https://jvns.ca/blog/2017/06/03/async-io-on-linux--select--poll--and-epoll/​
- DIO and AIO
	- Blog article: 'Different I/O Access Methods for Linux, What We Chose for Scylla, and Why', Avi Kivity, CTO, ScyllaDB : https://www.scylladb.com/2017/10/05/io-access-methods-scylla/
	- Blog article: 'Thread Pools in NGINX Boost Performance 9x!', NGINX : https://www.nginx.com/blog/thread-pools-boost-performance-9x/
	- Article: *Boost application performance using asynchronous I/O: Learn when and how to use the POSIX AIO API*, IBM DeveloperWorks : https://www.ibm.com/developerworks/library/l-async/index.html
- Linux Performance page, Brendan Gregg
	- http://www.brendangregg.com/linuxperf.html
	- iosnoop For Linux : http://www.brendangregg.com/blog/2014-07-16/iosnoop-for-linux.html
	- Linux iosnoop Latency Heat Maps : http://www.brendangregg.com/blog/2014-07-23/linux-iosnoop-latency-heat-maps.html
- Blog article: 'Using cgroups to limit I/O' : https://andrestc.com/post/cgroups-io/

## Ch 19, Troubleshooting and Best Practices : Further Reading

- Perf
	- *Linux Performance page*, Brendan Gregg : http://www.brendangregg.com/linuxperf.html
	- *Linux Performance Tools, Brendan Gregg, part 1 of 2, Velocity 2015*, YouTube video : https://www.youtube.com/watch?v=FJW8nGV4jxY&t=4s
	- Perf Flame Graphs : http://www.brendangregg.com/flamegraphs.html
	- FYI, *Using Perf on Android* : https://wiki.linaro.org/LMG/Engineering/UsingPerfOnAndroid
- 'Linux Performance and Tuning Guidelines', IBM/Lenovo Redpaper : https://lenovopress.com/redp4285.pdf
- Blog article: 'Linux tracing systems & how they fit together', J Evans
: https://jvns.ca/blog/2017/07/05/linux-tracing-systems/
- Blog article: 'LOW-LEVEL SOFTWARE DESIGN' : https://kaiwantech.wordpress.com/2017/01/03/low-level-software-design/
- Control Groups (cgroups): 'CHAPTER 1. INTRODUCTION TO CONTROL GROUPS (CGROUPS)', RedHat (RHEL7) : https://access.redhat.com/documentation/en-us/red_hat_enterprise_linux/7/html/resource_management_guide/chap-introduction_to_control_groups
- The Linux *proc* filesystem
	- "T H E /proc F I L E S Y S T E M" : https://www.kernel.org/doc/Documentation/filesystems/proc.txt
	- "Chapter 3. The proc File System", CentOS : https://www.centos.org/docs/5/html/Deployment_Guide-en-US/ch-proc.html
	- the man page on proc(5) : http://man7.org/linux/man-pages/man5/proc.5.html
- Blog articles
	- 'The Worst Computer Bugs in History: Losing $460m in 45 minutes' : https://blog.bugsnag.com/bug-day-460m-loss/
	- 'The Worst Computer Bugs in History: The Ariane 5 Disaster' : https://blog.bugsnag.com/bug-day-ariane-5-disaster/
	- Blog site : https://blog.bugsnag.com/
- 'A survey of some free fuzzing tools', LWN (Jan 2018) : https://lwn.net/Articles/744269/
- Blog article: 'Software optimization resources' (x86-biased): https://www.agner.org/optimize/

*Books*
- A Must Read! *The Mythical Man Month*, Frederick P. Brooks, 1975, 1995 (!)
- *Patterns in C: Patterns, Idioms and Design Principles*, Adam Tornhill, 2015
- *Systems Performance: Enterprise and the Cloud*, Brendan Gregg
- *The Pragmatic Programmer: From Journeyman to Master*, Hunt & Thomas
- *The Practice of Programming*, Kerninghan & Pike
- *Programming Pearls*, Jon Bentley
- *The Art of UNIX Programming*, E.S. Raymond


## A: File I/O Essentials : Further Reading

- 'File locking in Linux' - a tutorial : https://gavv.github.io/blog/file-locks/
- An article describing the stdbuf(1) utility: buffering in standard
streams: [http://www.pixelbeat.org/programming/stdio_buffering/](http://www.pixelbeat.org/programming/stdio_buffering/)
- 'Using setvbuf() with STDIN stream' : https://stackoverflow.com/questions/5876373/using-setvbuf-with-stdin-stream
- The popen(3) man page : http://man7.org/linux/man-pages/man3/popen.3.html
- 'Systemd Essentials: Working with Services, Units, and the Journal', 
DigitalOcean: https://www.digitalocean.com/community/tutorials/systemd-essentials-working-with-services-units-and-the-journal

## B: Daemon Processes : Further Reading

- The man page on daemon(7) is extremely detailed and guides the app
developer on how exactly to create both the "old-style" traditional and the modern "new-style" daemon process; look it up here : https://www.freedesktop.org/software/systemd/man/daemon.html
- Systemd
	- Article, DigitalOcean: 'Systemd Essentials: Working with Services,
Units, and the Journal' : https://www.digitalocean.com/community/tutorials/systemd-essentials-working-with-services-units-and-the-journal
	- Article, DigitalOcean: 'Understanding Systemd Units and Unit Files' :  https://www.digitalocean.com/community/tutorials/understanding-systemd-units-and-unit-files
	- Systemd Documentation : http://0pointer.de/blog/projects/systemd-docs.html
	- Systemd FAQs : https://www.freedesktop.org/wiki/Software/systemd/FrequentlyAskedQuestions/
- *Debug a daemon process* with Valgrind-GDB (vgdb) debugging. Look up this chapter of Valgrind's manual: *Using and understanding the Valgrind core: Advanced Topics* : http://valgrind.org/docs/manual/manual-core-adv.html

[End of Doc]
