package es.ugr.amaro.mapoverlay;

import java.util.List;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapActivity;
import com.google.android.maps.MapController;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;
import com.google.android.maps.Projection;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Paint.Align;
import android.graphics.Point;
import android.location.Address;
import android.location.Geocoder;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class MapOverlayActivity extends MapActivity implements OnClickListener{
    /** Called when the activity is first created. */
	MapView mapView;
	MapController mapController;
	GeoPoint geoPoint;
	TextView tv;
	float latitud=42,longitud=-4;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        tv=(TextView) findViewById(R.id.textView);
        Button boton= (Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);
        
        mapView=(MapView) findViewById(R.id.mapView);
        mapView.setBuiltInZoomControls(true);
        mapController=mapView.getController();
        int latE6=(int)(latitud*1e6);
        int lonE6=(int)(longitud*1e6);
        geoPoint = new GeoPoint(latE6,lonE6);
        mapController.animateTo(geoPoint);
        mapController.setZoom(7);
        
        MapOverlay mapOverlay = new MapOverlay();
        List<Overlay> overlays = mapView.getOverlays();
        overlays.clear();
        overlays.add(mapOverlay);
        mapView.invalidate(); 
    }

    class MapOverlay extends Overlay{
    	
    	String coordenadas;
    	int x,y;
    	@Override
    	public boolean draw(Canvas canvas, MapView mapView, 
    			            boolean shadow, long when){

    		super.draw(canvas, mapView, shadow);
 
    		// transforma geoPoint en pixeles
    		Point point=new Point();
    		Projection projection = mapView.getProjection();
    		projection.toPixels(geoPoint, point);
    		x=point.x;
    		y=point.y;
    		latitud=(float) (geoPoint.getLatitudeE6()*1e-6);
    		longitud=(float) (geoPoint.getLongitudeE6()*1e-6);
    		coordenadas=""+latitud+","+longitud;
    		
    		// dibuja circulo centrado en coordenadas
    		Paint paint=new Paint();
    		paint.setAntiAlias(true);
    		paint.setColor(Color.argb(100,255,0,0));
    		canvas.drawCircle(x, y, 25, paint);
    		// escribe coordenadas
    		paint.setColor(Color.BLACK);
    		paint.setTextSize(30);
    		paint.setTextAlign(Align.CENTER);
    		canvas.drawText(coordenadas, x, y-25, paint);
    		return true;
    	}
    	
    	@Override
    	public boolean onTouchEvent(MotionEvent event, MapView mapView){
    		
    		// Pasa pixeles a coordenadas del nuevo punto  		
    		if(event.getAction()==MotionEvent.ACTION_UP){
    			Projection projection=mapView.getProjection();
    			x= (int) event.getX();
    			y= (int) event.getY();
    			geoPoint=projection.fromPixels(x, y);
//    			mapController.animateTo(geoPoint);
    		}		
			return false;  		
    	}	
    }
    
    public void onClick(View v){
    	
    	Geocoder geocoder=new Geocoder(this);
    	String result="";
    	try {
			List<Address> lista= geocoder.getFromLocation(latitud, longitud, 1);
			if(lista.size()>0){
				Address address= lista.get(0);
				int n=address.getMaxAddressLineIndex();
				for(int i=0;i<n;i++){
					result=result+address.getAddressLine(i)+"\n";
				}		
				tv.setText(result);
			}			
		} catch (Exception e){
			tv.setText("Error en la direccion");
		}
    }
    
	@Override
	protected boolean isRouteDisplayed() {
		// TODO Auto-generated method stub
		return false;
	}

}