package es.ugr.amaro.contactos;

import android.app.Activity;
import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.widget.TextView;

public class ContactosActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        TextView tv=(TextView) findViewById(R.id.textView);
        
        //---URL de la tabla de contatos
        Uri uriContactos=ContactsContract.Contacts.CONTENT_URI;
        //---definicion alternativa---
        uriContactos=Uri.parse("content://com.android.contacts/contacts");
        String uriString=uriContactos.toString();
        tv.setText("uri de la tabla contactos:\n"+uriString);
        
        //---Definimos un ContentResolver
        ContentResolver resolver= getContentResolver();        
        String mime= resolver.getType(uriContactos);
        tv.append("\nMIME de la tabla contactos:\n"+mime);

        //---descomentar esto para obtener un unico contacto
//        uriContactos=Uri.parse(uriString+"/14");
//        mime= resolver.getType(uriContactos);
//        tv.append("\nMIME de un único contacto:\n"+mime);
        
        //---Busqueda de  contactos---
        Cursor cursor=resolver.query(uriContactos, null, 
        		            "has_phone_number", null, "display_name");
        
        int ncolumnas=cursor.getColumnCount();
        String[] nombreColumna=new String[ncolumnas];
        for(int i=0;i<ncolumnas;i++){
        nombreColumna[i]=cursor.getColumnName(i);	
        tv.append("\n"+i+","+nombreColumna[i]);
        }

        int displayNameIndex= cursor.getColumnIndex
                           (ContactsContract.Contacts.DISPLAY_NAME);
        tv.append("\n\nDISPLAY_NAME index="+displayNameIndex);
        int idIndex= cursor.getColumnIndex
        (ContactsContract.Contacts._ID);
        tv.append("\n_ID index="+idIndex);
        
        tv.append("\n\nTABLA DE CONTACTOS: _ID , DISPLAY_NAME");
        
        cursor.moveToFirst();
        int nfilas=cursor.getCount();
        for(int i=0;i<nfilas;i++){
        	String _id=cursor.getString(idIndex);
        	String display_name=cursor.getString(displayNameIndex);
        	tv.append("\n"+_id+","+display_name);
        	cursor.moveToNext();
        }        
        
    }
}