package es.ugr.amaro.aplicacionesinstaladas;

import java.util.ArrayList;
import java.util.List;
import android.app.Activity;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;

public class AplicacionesInstaladas extends Activity implements OnItemClickListener{

	TextView tv;
	ArrayList<Aplicacion> arrayList=new ArrayList<Aplicacion>();
	PackageManager manager;

    class Aplicacion{
    	String label,packageName,sourceDir;
    	Drawable icon;
    }
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);

    		manager=getPackageManager();
    		List<ApplicationInfo> lista=manager.getInstalledApplications(0);
    		int size=lista.size();
    		ApplicationInfo info;
            Aplicacion aplicacion;    
            
    		for(int i=0;i<size;i++){
    			info=lista.get(i);
    			aplicacion=new Aplicacion();
    			aplicacion.packageName=info.packageName;
    			aplicacion.sourceDir=info.sourceDir;
    			aplicacion.label=(String) info.loadLabel(manager);
    			aplicacion.icon= info.loadIcon(manager);    			
    			arrayList.add(aplicacion);
    		}
    		
    		tv.append(" total: "+size);
    		ListView listView=(ListView) findViewById(R.id.listView1);
    		Adaptador adapter=new Adaptador();     		
    		listView.setAdapter(adapter);
    		listView.setOnItemClickListener(this);
    }
    
    
    class Adaptador extends BaseAdapter{
    	
    	LayoutInflater inflater;
    	View view;
    	TextView tv1,tv2,tv3;
    	ImageView icon;
    	
    	Adaptador(){
    		inflater= getLayoutInflater();   
		}
    	
		@Override
		public int getCount() {
			// TODO Auto-generated method stub
			return arrayList.size();
		}
		@Override
		public Object getItem(int position) {
			// TODO Auto-generated method stub
			return arrayList.get(position);
		}
		@Override
		public long getItemId(int position) {
			// TODO Auto-generated method stub
			return position;
		}
		@Override
		public View getView(int item, View oldView, ViewGroup parent) {
			// TODO Auto-generated method stub

    		view=inflater.inflate(R.layout.fila, null);
			tv1=(TextView) view.findViewById(R.id.textView1);
			tv2=(TextView) view.findViewById(R.id.textView2);
			tv3=(TextView) view.findViewById(R.id.textView3);
			icon=(ImageView) view.findViewById(R.id.imageView1);
			tv1.setText(item + " " +arrayList.get(item).label);
			tv2.setText(arrayList.get(item).packageName);
			tv3.setText(arrayList.get(item).sourceDir);			
			icon.setImageDrawable(arrayList.get(item).icon);			

			return view;
		}
    }
        

	@Override
	public void onItemClick(AdapterView<?> av, View v, int position, long id) {
		// TODO Auto-generated method stub

		try{
		String paquete=arrayList.get(position).packageName;
		Intent intent=manager.getLaunchIntentForPackage(paquete);
		startActivity(intent);
		} catch (Exception e)
		{;}	
	}
}