package es.ugr.amaro.activityLife;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;

public class ActivityLifeActivity extends Activity{

	int state=0;
	TextView tv;
	String texto="Secuencia de Vida de la actividad";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        try{
        state=savedInstanceState.getInt("estado",0);
        texto=savedInstanceState.getString("texto");
        texto=texto+"\nRestablecido estado";
        } catch(Exception e){
        }
        state++;
        texto=texto+"\n"+state+" onCreate";
    }

    @Override
    public void onRestoreInstanceState(Bundle savedInstanceState){
    	super.onRestoreInstanceState(savedInstanceState);
    	state++;
    	texto=texto+"\n"+state+" onRestoreInstanceState";
    }
    
    @Override 
    public void onRestart(){
    	super.onRestart();
    	state++;
    	texto=texto+"\n"+state+" onRestart";
    }
    
    @Override 
    public void onStart(){
    	super.onStart();
    	state++;
    	texto=texto+"\n"+state+" onStart";
    }
    
    @Override 
    public void onResume(){
    	super.onResume();
    	state++;
    	texto=texto+"\n"+state+" onResume";
    	tv.setText(texto);
    }

    @Override
    public void onSaveInstanceState(Bundle savedInstanceState){
    	super.onSaveInstanceState(savedInstanceState);
    	state++;
    	texto=texto+"\n"+state+" onSaveInstanceState";
    	Toast.makeText(this,"onSaveInstanceState",0).show();
    	savedInstanceState.putInt("estado", state);
    	savedInstanceState.putString("texto", texto);	
    }
        
    @Override 
    public void onPause(){
    	super.onPause();
    	state++;
    	texto=texto+"\n"+state+" onPause";
    	Toast.makeText(this,"onPause",0).show();
    }
    
    @Override 
    public void onStop(){
    	super.onStop();
    	state++;
    	texto=texto+"\n"+state+" onStop";
    	Toast.makeText(this, "onStop", 0).show();	
    }
    
    @Override 
    public void onDestroy(){
    	super.onDestroy();
    	state++;
    	texto=texto+"\n"+state+" onDestroy";
    	Toast.makeText(this, "onDestroy", 0).show();
    }
}