package es.ugr.amaro.sqlitehelper;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabase.CursorFactory;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Bundle;
import android.widget.TextView;

public class SQLiteHelperActivity extends Activity {

	TextView tv;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        
        SQLiteHelper sqliteHelper = new SQLiteHelper(this,"musica.db",null,1);
        SQLiteDatabase db= sqliteHelper.getWritableDatabase();
        
        ContentValues values= new ContentValues();
        values.put("titulo", "Don Giovanni");
        values.put("compositor", "W.A. Mozart");
        values.put("year", 1787);
        db.insert("operas",null, values);
        
        Cursor cursor=db.query("operas", null, null, null, null, null, null);
 
        String titulo,compositor,year;
        tv.append("\n  Tabla operas    \n---------");
        cursor.moveToFirst();
        int filas= cursor.getCount();
        for (int i=0;i<filas;i++){
        	titulo = cursor.getString(1);
        	compositor=cursor.getString(2);
        	year=cursor.getString(3);
        	tv.append("\n"+titulo+" "+compositor+" "+year);
        	cursor.moveToNext();
        }
           
        db.close();
     
    }
    
    
    class SQLiteHelper extends SQLiteOpenHelper{

		public SQLiteHelper(Context context, String name,
				CursorFactory factory, int version) {
			super(context, name, factory, version);
		}

		@Override
		public void onCreate(SQLiteDatabase db) {
			// TODO Auto-generated method stub
			db.execSQL("create table if not exists "+ 
					"operas (id integer primary key, titulo text, "+
					" compositor text, year integer);");
		}

		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {			
		}
    	
    }   //---end SQLiteHelper   
}