package es.ugr.amaro.descargarimagen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

public class DescargarImagenActivity extends Activity implements OnClickListener{
	TextView tv;
	String direccion="http://www.ugr.es/~amaro/gatos/bigcats/borro01.jpg";
	
	@Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        Button boton=(Button) findViewById(R.id.button1);
        boton.setOnClickListener(this);        
    }

	@Override
	public void onClick(View v) {
		Bitmap bitmap=null;
		InputStream input=null;		
		try {
			URL url=new URL(direccion);
			HttpURLConnection conexion= (HttpURLConnection) url.openConnection();
			input= conexion.getInputStream();
			bitmap = BitmapFactory.decodeStream(input);
			input.close();
			ImageView imageView = (ImageView) findViewById(R.id.imageView1);
			if(bitmap !=null) imageView.setImageBitmap(bitmap);
			guardar(bitmap);
						
		} catch (Exception e) {
			tv.setText("uses_permission INTERNET");
		}	
	}
	
	void guardar(Bitmap bitmap)  {
		
		File rootFile=Environment.getExternalStorageDirectory();
		String root=rootFile.getAbsolutePath();
		tv.append("\n"+root);
		String dir=root+"/descargas";
		File dirFile= new File(dir);
		boolean existe=dirFile.mkdir();
		if(existe) tv.append("\nDirectorio "+dir+" creado");
		else tv.append("\nDirectorio "+dir+" ya existe");
		String file=Uri.parse(direccion).getLastPathSegment();
		tv.append("\nEscribiendo file"+file);
		File fileFile=new File(dirFile,file);
		if(fileFile.exists()){
			tv.append("\nFichero "+file+" ya existe");
		} else{
			try {
				FileOutputStream stream= new FileOutputStream(fileFile);
				bitmap.compress(Bitmap.CompressFormat.JPEG, 50, stream);
				stream.flush();
				stream.close();
				tv.append("\nFichero grabado");
				
			} catch (Exception e) {
				e.printStackTrace();
				tv.append("\nError "+e);
			}
		}	
	}
}