package es.ugr.amaro.parsexml;

import java.io.InputStream;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;

public class ParseXMLActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        TextView tv=(TextView) findViewById(R.id.textView);
        
        //---lee fichero xml
        InputStream input = getResources().openRawResource(R.raw.rss2);
        //---nueva factoria de constructores de documentos
        DocumentBuilderFactory factory=DocumentBuilderFactory.newInstance();
        try {
        	//---nuevo constructor de documentos
        	DocumentBuilder builder=factory.newDocumentBuilder();
        	//---convierte el XML en un documento 
			Document doc=builder.parse(input);
			doc.normalize();
			
			//---Nodo principal del documento
			Node nodoPrincipal=doc.getDocumentElement();
			String nombreNodo=nodoPrincipal.getNodeName();
			tv.append("\nNodo principal: "+nombreNodo);
			
			//---lista de todos los elementos
			NodeList nodeList=doc.getElementsByTagName("*");
			int nNodes=nodeList.getLength();
			tv.append("\nNumero de elementos= "+nNodes);
			Node nodo;
			tv.append("\n------------------------"
			         +"\nLista de todos los elementos"
			         +"\n------------------------");
				
			for(int i=0;i<nNodes;i++){
				//---toma el nodo i
				nodo=nodeList.item(i);
				nombreNodo=nodo.getNodeName();
				tv.append("\n"+nombreNodo);
			}
        
		} catch (Exception e){
			tv.append("\nError de XML");
		}
		 
    }
}