package es.ugr.amaro.metrics;

import android.app.Activity;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.widget.TextView;

public class MetricsActivity extends Activity {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        TextView tv=(TextView) findViewById(R.id.textView);        

        // Dimensiones de la pantalla
        DisplayMetrics metrics=getResources().getDisplayMetrics();
        
        // densidad lógica=densityDpi/160
        float density=metrics.density;
        // 
        int densityDpi=metrics.densityDpi;
        int densityLow=metrics.DENSITY_LOW;
        int densityHigh=metrics.DENSITY_HIGH;
        int densityMedium=metrics.DENSITY_MEDIUM;
        int height=metrics.heightPixels;
        int width=metrics.widthPixels;
        float xdpi=metrics.xdpi;
        float ydpi=metrics.ydpi;
        
        tv.append("\ndensity="+density
        	 +"\ndensityDpi/160="+(densityDpi/160.0)
       		 +"\ndensityDpi="+densityDpi
    		 +"\nDENSITY_LOW="+densityLow
    		 +"\nDENSITY_HIGH="+densityHigh
    		 +"\nDENSITY_MEDIUM="+densityMedium
    		 +"\nheight="+height
    		 +"\nwidth="+width
    		 +"\nxdpi="+xdpi
    		 +"\nydpi="+ydpi);
    }
}