package es.ugr.amaro.explora;

import android.app.Activity;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Browser;
import android.provider.CallLog;
import android.provider.MediaStore;
import android.provider.Settings;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class ExploraActivity extends Activity implements OnClickListener {
	TextView tv,tv1;
	int nbotones;
    Uri[] uri={
          CallLog.Calls.CONTENT_URI,
          Settings.System.CONTENT_URI,
          Settings.Secure.CONTENT_URI,
          Browser.BOOKMARKS_URI,
          Browser.SEARCHES_URI,
          MediaStore.Audio.Media.EXTERNAL_CONTENT_URI,
          MediaStore.Audio.Media.INTERNAL_CONTENT_URI,
          MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
          MediaStore.Images.Media.INTERNAL_CONTENT_URI,
          MediaStore.Video.Media.EXTERNAL_CONTENT_URI,
          MediaStore.Video.Media.INTERNAL_CONTENT_URI,
    };
    
    String[] tabla={"CallLog Calls",
    		        "Settings System",
    		        "Settings secure",
    		        "Browser bookmarks",
    		        "Browser searches",
    		        "Audio media external",
    		        "Audio media internal",
    		        "Images media external",
    		        "Images media internal",
    		        "Video media external",
    		        "Video media internal"    		
    };
    
    int[] idBoton= {R.id.button0,R.id.button1,R.id.button2,R.id.button3,
    		        R.id.button4,R.id.button5,R.id.button6,R.id.button7,
    		        R.id.button8,R.id.button9,R.id.button10};
    
	/** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        tv=(TextView) findViewById(R.id.textView);
        tv1=(TextView) findViewById(R.id.textView1);        
        
        nbotones=idBoton.length;
        Button[] boton=new Button[11];
    
        for (int i=0;i<nbotones;i++){
        	boton[i]=(Button) findViewById(idBoton[i]);
        	boton[i].setOnClickListener(this);
        }           
    }


	@Override
	public void onClick(View v) {

		int id=v.getId();		
		for (int i=0;i<nbotones;i++){
			if(id==idBoton[i]){
				muestraTabla(uri[i]);
				tv1.setText("Tabla "+tabla[i]);
			}
		}
	}
    
    
    void muestraTabla(Uri uri){

        tv.setText("URI tabla:\n"+uri);        
        Cursor cursor=getContentResolver().query(uri,null,null,null,null);
        String[] columnas= cursor.getColumnNames();
        int ncolumnas=columnas.length;
        for (int i=0;i<ncolumnas;i++){
        	tv.append("\n"+i+" : "+columnas[i]);
        }
        
        String columna;
        int nfilas=cursor.getCount();
        tv.append("\nNumero de filas:"+nfilas);
        cursor.moveToFirst();
        for (int i=0;i<nfilas;i++){	
        	tv.append("\n");
        	for(int j=0;j<ncolumnas;j++){
        		try{ columna=cursor.getString(j);}
        		catch(Exception e){ columna="unreadable";}
        		tv.append(" : "+columna);
        	}
        	cursor.moveToNext();
        }
     }
}