import React from 'react';
import { mount } from 'enzyme';
import renderer from 'react-test-renderer';
import { enzymeFind } from 'styled-components/test-utils';
import 'jest-styled-components';
import HeaderBg from '../HeaderBg';

describe('<HeaderBg />', () => {
  it('should match snapshot', () => {
    const rendereredComponent = renderer.create(<HeaderBg />).toJSON();
    expect(rendereredComponent).toMatchSnapshot();
  });

  it('should have a className attribute', () => {
    const rendereredComponent = enzymeFind(mount(<HeaderBg />), HeaderBg);
    expect(rendereredComponent.prop('className')).toBeDefined();
  });

  it('should adopt a valid attribute', () => {
    const id = 'test';
    const rendereredComponent = enzymeFind(
      mount(<HeaderBg id={id} />),
      HeaderBg,
    );
    expect(rendereredComponent.prop('id')).toEqual(id);
  });

  it('should not adopt an invalid attribute', () => {
    const rendereredComponent = enzymeFind(
      mount(<HeaderBg something="test" />),
      HeaderBg,
    );
    expect(rendereredComponent.prop('something')).toBeUndefined();
  });
});
